/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import java.util.regex.Pattern;

public class QueryLiteralRemover {
    private static final Pattern NUMBER_PARAM_PATTERN = Pattern.compile("(?<=[-+*/,_<=>)(\\.\\s;])\\d+(?=[-+*/,_<=>)(\\.\\s;]|$)");
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("'(.*?[^\\'])??'(?!')"), Pattern.compile("\"(.*?[^\\\"])??\"(?!\")"), NUMBER_PARAM_PATTERN};
    private static final String REPLACER = "?";

    public static String removeLiterals(String sql) {
        if (sql == null || sql.length() == 0) {
            return sql;
        }
        for (Pattern p : PATTERNS) {
            sql = p.matcher(sql).replaceAll(REPLACER);
        }
        return sql;
    }
}

