/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.parser.StatementParser;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.apminsight.agent.trackers.db.PreparedQueryExtractor;
import com.manageengine.apminsight.agent.trackers.db.QueryHolder;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.util.List;

public class StatementTracker
extends AbstractDBTracker {
    protected Object[] args;
    protected Object statement;

    public StatementTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args, boolean isPreparedStatement) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = false;
        this.args = args;
        if ("executeBatch".equals(pointcutProperties.getInterceptedMethodName())) {
            this.queries = this.getBatchAddedSQLs(thiz, isPreparedStatement);
            this.startTime = System.currentTimeMillis();
        } else if (isPreparedStatement) {
            this.statement = thiz;
        }
        if (JavaAgentConfig.captureHostDetails) {
            this.serverAddress = StatementParser.getAddress(thiz);
        }
    }

    @Override
    protected void quit() {
        super.quit();
        if (!"executeBatch".equals(this.pointcutProperties.getInterceptedMethodName())) {
            if (this.statement != null) {
                try {
                    String className = this.statement.getClass().getName();
                    String sql = null;
                    sql = className.contains("mysql") ? ((sql = this.statement.toString()).contains(": ") ? sql.split(": ", 2)[1] : sql) : (className.contains("postgresql") ? this.statement.toString() : this.getPreparedQuery(this.statement));
                    if (sql != null) {
                        this.queries = new String[]{sql};
                    }
                }
                catch (Exception e) {
                    JavaAgent.logger.log(Level.WARN, "Unable to fetch query for pointcut: " + this.pointcutProperties.toString(), e);
                }
            } else if (this.args != null && this.args[0] != null) {
                this.queries = new String[]{(String)this.args[0]};
            } else {
                JavaAgent.logger.warn("args holds no query in call " + this.pointcutProperties.getInterceptedClassName() + "." + this.pointcutProperties.getInterceptedMethodName() + "()");
            }
        }
        this.statement = null;
        this.args = null;
    }

    protected String[] getBatchAddedSQLs(Object statement, boolean isPreparedStatement) {
        if (isPreparedStatement) {
            String query = QueryHolder.getPreparedQuery(statement);
            if (query != null) {
                return new String[]{query};
            }
            return null;
        }
        List<String> batchQueries = SequenceSpace.SEQUENCE_BOOK.get().getQueryHolder().removeBatchQueries(statement);
        if (batchQueries == null) {
            JavaAgent.logger.debug("Attempt to get batchQueries from cache failed. Attempting reflection.");
            return this.getBatchAddedSQLsByReflection(statement, isPreparedStatement);
        }
        return batchQueries.toArray(new String[batchQueries.size()]);
    }

    protected String[] getBatchAddedSQLsByReflection(Object statement, boolean isPreparedStatement) {
        Class<?> clz = statement.getClass();
        String className = clz.getName();
        if (isPreparedStatement) {
            clz = clz.getSuperclass();
        }
        List batchedArgs = null;
        try {
            String fieldStr = "batchedArgs";
            if (className.contains("mysql")) {
                fieldStr = "batchedArgs";
            } else if (className.contains("jtds")) {
                fieldStr = "batchValues";
            } else if (className.contains("oracle")) {
                fieldStr = "m_batchItems";
            } else if (className.contains("ibm")) {
                fieldStr = "batchValues";
            }
            Field field = clz.getDeclaredField(fieldStr);
            field.setAccessible(true);
            batchedArgs = (List)field.get(statement);
        }
        catch (Exception fieldStr) {
            // empty catch block
        }
        if (batchedArgs != null) {
            String[] batchedSQLs = new String[batchedArgs.size()];
            int i = 0;
            for (Object batchedQuery : batchedArgs) {
                if (batchedQuery == null) continue;
                batchedSQLs[i++] = batchedQuery.toString();
            }
            if (batchedArgs.size() != i) {
                String[] batchdSQLs = new String[i];
                System.arraycopy(batchedSQLs, 0, batchdSQLs, 0, i);
                batchedSQLs = batchdSQLs;
            }
            return batchedSQLs;
        }
        RootTracker rt = SequenceSpace.SEQUENCE_BOOK.get().getRootTracker();
        JavaAgent.logger.log(Level.WARN, "Attempt to extract batch queries failed for Statement: {} Web-Transaction: {}", statement.getClass().getName(), rt != null ? rt.getSequenceNameSpace() : " rootTracker is null");
        return null;
    }

    private String getPreparedQuery(Object prepStmt) {
        String query = QueryHolder.getPreparedQuery(prepStmt);
        if (query == null) {
            boolean attemptByReflection = JavaAgent.getInstance().agentConfig.captureSqlByReflection;
            JavaAgent.logger.debug("PreparedQuery not found in PreparedQueryStore. Attempt by reflection: " + attemptByReflection);
            if (attemptByReflection) {
                query = PreparedQueryExtractor.getPreparedQueryByReflection(prepStmt);
            }
        }
        return query;
    }
}

