/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.elasticsearch;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Arrays;

public class ElasticSearchRestHighLevelClientTracker
extends DefaultTracker {
    private StringBuilder index_type;

    public ElasticSearchRestHighLevelClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
        try {
            Object[] obj;
            Class<?> requestClz = args[0].getClass();
            this.index_type = new StringBuilder();
            try {
                this.index_type.append((String)requestClz.getMethod("index", new Class[0]).invoke(args[0], new Object[0]));
            }
            catch (NoSuchMethodException e) {
                obj = (Object[])requestClz.getMethod("indices", new Class[0]).invoke(args[0], new Object[0]);
                this.index_type.append(Arrays.deepToString(obj));
            }
            this.index_type.append(" / ");
            try {
                this.index_type.append((String)requestClz.getMethod("type", new Class[0]).invoke(args[0], new Object[0]));
            }
            catch (NoSuchMethodException e) {
                obj = (Object[])requestClz.getMethod("types", new Class[0]).invoke(args[0], new Object[0]);
                this.index_type.append(Arrays.deepToString(obj));
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[ElasticSearchRestHighLevelClientTracker] Unable to extract query info for Elasticsearch call. Exception: " + e.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        signature.append(" - ");
        signature.append(this.pointcutProperties.getInterceptedMethodName().toUpperCase());
        if (this.index_type != null) {
            signature.append(" - ");
            signature.append(this.index_type.toString());
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

