/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class JaxRSRequestTracker
extends WebSeqRootTracker {
    private String txnName;

    public JaxRSRequestTracker(PointcutProperties pointcut, String seqName, String httpMethod) {
        super(pointcut, null, null);
        this.txnName = StringUtils.isEmptyString(seqName) ? "unknown" : seqName;
        this.httpMethod = httpMethod;
    }

    @Override
    protected String assignSequenceName() {
        this.unnormalizedSeqName = this.txnName;
        this.seqName = SequenceURINormalizer.normalizeURI(this.txnName);
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(2, 1.0f);
        if (this.httpMethod != null) {
            xtraMetrics.put("http_method_name", this.httpMethod);
        }
        return xtraMetrics;
    }
}

