/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;

public class JettyHttpClientTracker
extends AbstractHttpClientTracker {
    public JettyHttpClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.httpUrl = this.getRequestUrl(thiz);
        this.method = this.getHttpMethod(thiz);
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.statusCode = this.getStatusCode(returnValue);
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Method m = requestObject.getClass().getMethod("getURI", new Class[0]);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JettyClientTracker] Error retrieving uri from Jetty Client. Exception: " + th.getMessage());
            return this.httpUrl;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Method m = requestObject.getClass().getMethod("getMethod", new Class[0]);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            return this.method;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("getStatus", new Class[0]);
            return (Integer)m.invoke(respObj, new Object[0]);
        }
        catch (Throwable throwable) {
            return this.statusCode;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        return null;
    }
}

