/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.httpclient.async.AbstractAsyncHttpClientTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ApacheHttpClientAsyncTracker
extends AbstractAsyncHttpClientTracker {
    public ApacheHttpClientAsyncTracker(PointcutProperties pointcutData, Object thiz, Object[] args) {
        super(pointcutData, thiz, null);
        try {
            this.setCallbackObj(args[args.length - 1]);
            this.httpUrl = this.getRequestUrl(args[0]);
            this.method = this.getHttpMethod(args[0]);
            this.setDTHeaderInRequest(args[0]);
            if (!(this.httpUrl != null && this.httpUrl.startsWith("http") || args.length <= 1 || args[1] == null)) {
                this.httpUrl = args[1].toString() + (this.httpUrl != null ? (this.httpUrl.length() > 0 && this.httpUrl.charAt(0) == '/' ? this.httpUrl : "/" + this.httpUrl) : "/");
            }
        }
        catch (Throwable th) {
            this.httpUrl = null;
            JavaAgent.logger.warn("[ApacheAsyncHttpClientTracker] Unable to construct the http url. Exception: " + th.getMessage());
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (this.getCallbackObj() == null && returnValue != null && returnValue.getClass().getSimpleName().equals("FutureWrapper")) {
            try {
                Field f = returnValue.getClass().getDeclaredField("future");
                f.setAccessible(true);
                this.setCallbackObj(f.get(returnValue));
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("[ApacheAsync] Unable to get callback obj {}", th.getMessage());
            }
        }
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Method getURI = requestObject.getClass().getMethod("getURI", new Class[0]);
            getURI.setAccessible(true);
            return getURI.invoke(requestObject, new Object[0]) + "";
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "ApacheAsyncHttpClientRequest Unable to get request URL. " + th.getMessage());
            return this.httpUrl;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Class<?> clz = requestObject.getClass();
            Method m = clz.getMethod("getMethod", new Class[0]);
            m.setAccessible(true);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheAsyncHttpClient] Unable to get request type. " + th);
            return this.method;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("getStatusLine", new Class[0]);
            Object statusline = m.invoke(respObj, new Object[0]);
            m = statusline.getClass().getMethod("getStatusCode", new Class[0]);
            return (Integer)m.invoke(statusline, new Object[0]);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheAsyncHttpClient] Unable to get status code. " + th);
            return this.statusCode;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.getConfig() != null && seqSpace.getConfig().isDistributedTracingEnabled()) {
                Class<?> reqClass = requestObject.getClass();
                Method m = reqClass.getMethod("setHeader", String.class, String.class);
                m.invoke(requestObject, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                JavaAgent.logger.debug("[DistributedTracing] Outgoing request id added to header " + this.httpUrl);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Unable to set DT header in request. Exception: " + e.getMessage());
        }
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        try {
            Class<?> respClass = respObj.getClass();
            Method m = respClass.getMethod("getFirstHeader", String.class);
            m.setAccessible(true);
            Object header = m.invoke(respObj, "X-Site24x7-DT-Data");
            if (header != null) {
                m = header.getClass().getMethod("getValue", new Class[0]);
                return (String)m.invoke(header, new Object[0]);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheAsyncHttpClient] Exception while reading response header. " + th.getMessage());
        }
        return this.dtData;
    }
}

