/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.mongodb;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MongoDBTracker
extends DefaultTracker
implements DatabaseTracker,
MetricConstants {
    private Object dcObj;
    private String dbName;
    private String collectionName;
    private String serverAddress;
    private String criteria;

    public MongoDBTracker(PointcutProperties pointcut, Object thiz, Object[] args) {
        super(pointcut, thiz, args);
        this.isLeafTracker = true;
        this.dcObj = thiz;
        if (args.length > 0) {
            this.criteria = args[0] != null && args[0] instanceof List ? Arrays.deepToString(((List)args[0]).toArray()) : (pointcut.getInterceptedMethodName().equals("update") && args[1] != null ? args[1].toString() : args[0].toString());
        }
    }

    @Override
    protected void quit() {
        super.quit();
        this.getQueryInfo();
        this.dcObj = null;
    }

    private void getQueryInfo() {
        try {
            Method method = this.dcObj.getClass().getMethod("getName", new Class[0]);
            this.collectionName = method.invoke(this.dcObj, new Object[0]).toString();
            method = this.dcObj.getClass().getMethod("getDB", new Class[0]);
            Object obj = method.invoke(this.dcObj, new Object[0]);
            method = obj.getClass().getMethod("getName", new Class[0]);
            this.dbName = method.invoke(obj, new Object[0]).toString();
            if (JavaAgentConfig.captureHostDetails) {
                method = obj.getClass().getMethod("getMongo", new Class[0]);
                obj = method.invoke(obj, new Object[0]);
                method = obj.getClass().getMethod("getAddress", new Class[0]);
                this.serverAddress = method.invoke(obj, new Object[0]).toString();
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[MongoDB] Error occurred while capturing additional info. Exception:" + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        this.serverAddress = InetAddressUtil.standardizeServerAddress(this.serverAddress);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddress, this.duration - childDuration, this.isErroneous());
        return true;
    }

    private String constructQuery() {
        StringBuilder query = new StringBuilder();
        query.append(this.dbName);
        query.append('.');
        query.append(this.collectionName);
        query.append('.');
        query.append(this.pointcutProperties.getInterceptedMethodName());
        query.append('(');
        query.append(this.criteria != null ? this.criteria : "");
        query.append(')');
        return query.toString();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> addInfo) {
        addInfo.put("query", this.constructQuery());
        return addInfo;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        signature.append(" - ");
        signature.append(this.pointcutProperties.getInterceptedMethodName().toUpperCase());
        if (!StringUtils.isEmptyString(this.serverAddress)) {
            signature.append(" - ");
            try {
                signature.append(this.serverAddress.split("/")[1]);
            }
            catch (Exception e) {
                signature.append(this.serverAddress);
            }
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

