/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.troubleshoot;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.communication.ProxyConfig;
import com.manageengine.apminsight.agent.communication.http.HttpClientBuilder;
import com.manageengine.apminsight.agent.communication.http.HttpConfig;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.SecurityUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class AgentTroubleshooter
implements JavaAgentConstants {
    private File agentDir;
    private Properties agentConf = null;
    private static final String STATUS = "STATUS: {0}";
    private static final String OK = "OK";
    private static final String FAILED = "FAILED";
    private static final String DIAGNOSTICS_FILENAME_PREFIX = "apminsight-diagnostics-";

    public AgentTroubleshooter(String agentDir) {
        try {
            this.agentDir = new File(agentDir);
        }
        catch (Throwable th) {
            this.agentDir = new File("");
        }
        try {
            this.agentConf = Utils.getContentAsProps(new File(agentDir, "apminsight.conf"));
        }
        catch (Throwable th) {
            this.agentConf = new Properties();
        }
    }

    public void troubleshoot(boolean createDiagnosticsFile) {
        try {
            File agentJarFile = new File(this.agentDir, "apminsight-javaagent.jar");
            if (!agentJarFile.exists()) {
                JavaAgentUtil.print("The current directory does not contain the agent jar. " + this.agentDir.getAbsolutePath());
                JavaAgentUtil.print("Unable to troubleshoot the agent. Quitting...");
                return;
            }
            this.checkRWPermissions();
            boolean isLicensePresent = this.checkLicenseKey();
            if (isLicensePresent) {
                try {
                    JavaAgentUtil.encryptSensitiveData(new File(this.agentDir, "apminsight.conf"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.checkAgentState();
            this.checkNetworkConnectivity();
            if (createDiagnosticsFile) {
                this.zipAgentDirectory();
            }
        }
        catch (Throwable th) {
            JavaAgentUtil.print("Encountered error during troubleshooting. Quitting.." + th);
        }
    }

    private boolean checkRWPermissions() {
        JavaAgentUtil.print("\nChecking Read/Write permissions for agent directory...");
        boolean isPassed = false;
        if (this.agentDir.canRead() && this.agentDir.canWrite()) {
            JavaAgentUtil.print(MessageFormat.format(STATUS, OK));
            isPassed = true;
        } else {
            JavaAgentUtil.print("Provide full RW permissions for the agent directory & its contents");
            JavaAgentUtil.print(MessageFormat.format(STATUS, FAILED));
        }
        JavaAgentUtil.print("Note: Kindly make sure the user running the app server has R/W permissions over the agent directory");
        return isPassed;
    }

    private boolean checkLicenseKey() {
        JavaAgentUtil.print("\nChecking the license key in apminsight.conf file...");
        try {
            String license = this.agentConf.getProperty("license.key");
            if (!StringUtils.isEmptyString(license)) {
                JavaAgentUtil.print(MessageFormat.format(STATUS, OK));
                return true;
            }
            JavaAgentUtil.print("Specify the license key in apminsight.conf file");
        }
        catch (Exception e) {
            JavaAgentUtil.print("Error occurred while inspecting apminsight.conf file.\n" + e);
        }
        JavaAgentUtil.print(MessageFormat.format(STATUS, FAILED));
        return false;
    }

    private boolean checkAgentState() {
        JavaAgentUtil.print("\nChecking agent state...");
        boolean isOK = false;
        try {
            File infoFile = new File(this.agentDir, "apminsight.info");
            if (infoFile.exists()) {
                Properties info = Utils.getContentAsProps(infoFile);
                String state = info.getProperty("agent.state");
                if (AgentState.UNMANAGED.toString().equals(state)) {
                    JavaAgentUtil.print("Agent is in UNMANAGED(suspended) state. Activate the agent from APM Insight web console");
                } else if (AgentState.DELETED.toString().equals(state)) {
                    JavaAgentUtil.print("Agent is in DELETED state.\nTo activate this agent, delete " + infoFile.getName() + " and restart the app server");
                } else {
                    isOK = true;
                }
            } else {
                isOK = true;
            }
        }
        catch (IOException e) {
            JavaAgentUtil.print("Error occurred while inspecting agent state.\n" + e);
        }
        JavaAgentUtil.print(MessageFormat.format(STATUS, isOK ? OK : FAILED));
        return isOK;
    }

    private boolean checkNetworkConnectivity() {
        JavaAgentUtil.print("\nChecking network connectivity...");
        try {
            boolean isProxySet;
            String url = this.agentConf.getProperty("apm.host");
            if (url == null) {
                url = JavaAgentUtil.getDataCenter(this.agentConf.getProperty("license.key")).getCollectorDomain();
            } else if (this.agentConf.getProperty("apm.port") != null) {
                boolean isHttps = Boolean.parseBoolean(this.agentConf.getProperty("apm.protocol.https"));
                url = (isHttps ? "https://" : "http://") + url + ":" + this.agentConf.getProperty("apm.port");
            }
            HttpClientBuilder builder = new HttpClientBuilder().setHttpConfig(new HttpConfig(5, 20));
            String behindProxy = this.agentConf.getProperty("behind.proxy");
            boolean bl = isProxySet = behindProxy == null ? false : Boolean.parseBoolean(behindProxy);
            if (isProxySet) {
                JavaAgentUtil.print("Connecting via proxy...");
                String pswd = this.agentConf.getProperty("proxy.auth.password", "");
                try {
                    String plainText = SecurityUtil.decryptString(pswd, this.agentConf.getProperty("license.key"));
                    pswd = plainText != null ? plainText : pswd;
                    builder.setProxyConfig(new ProxyConfig(this.agentConf.getProperty("proxy.server.host"), this.agentConf.getProperty("proxy.server.port"), this.agentConf.getProperty("proxy.auth.username", ""), pswd));
                }
                catch (Exception e) {
                    JavaAgentUtil.print(e.getMessage() + " Ignoring proxy details");
                }
            }
            JavaAgentUtil.print("Connecting to " + url + " ...");
            CloseableHttpClient client = builder.build();
            HttpGet request = new HttpGet(url);
            int response = client.execute(request).getCode();
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JavaAgentUtil.print("HTTP Status Code: " + response);
            if (response == 200) {
                JavaAgentUtil.print(MessageFormat.format(STATUS, OK));
                return true;
            }
        }
        catch (Exception e) {
            JavaAgentUtil.print("Error occurred while checking connectivity.\n" + e);
        }
        JavaAgentUtil.print(MessageFormat.format(STATUS, FAILED));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zipAgentDirectory() {
        JavaAgentUtil.print("\nGenerating diagnostics file...");
        ZipOutputStream zipOutStream = null;
        FileOutputStream fileOutputStream = null;
        FileInputStream inputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String fileName = DIAGNOSTICS_FILENAME_PREFIX + dateFormat.format(new Date()).toString() + ".zip";
            File logDir = null;
            String logDirPath = this.agentConf.getProperty("apminsight.log.dir");
            if (logDirPath != null) {
                logDir = new File(logDirPath);
            }
            File[] dirsToZip = new File[]{this.agentDir, logDir};
            File zipfile = new File(this.agentDir, fileName);
            fileOutputStream = new FileOutputStream(zipfile);
            zipOutStream = new ZipOutputStream(fileOutputStream);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("apminsight.*.log.*|.*.conf|apminsight.info");
                }
            };
            for (File dir : dirsToZip) {
                if (dir == null) continue;
                for (File file : dir.listFiles(filter)) {
                    int length;
                    ZipEntry entry = new ZipEntry(file.getName());
                    zipOutStream.putNextEntry(entry);
                    inputStream = new FileInputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) >= 0) {
                        zipOutStream.write(buffer, 0, length);
                    }
                    inputStream.close();
                    zipOutStream.closeEntry();
                }
                zipOutStream.flush();
            }
            JavaAgentUtil.print("Agent diagnostics file generated.");
            JavaAgentUtil.print(zipfile.getAbsolutePath());
            JavaAgentUtil.print("Send the diagnostics zip to our support team for further assistance.");
        }
        catch (IOException e) {
            JavaAgentUtil.print("Error occurred while generating agent diagnostics file.\n" + e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipOutStream != null) {
                    zipOutStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Throwable th) {
                JavaAgentUtil.print("Error closing the diagnostics archive. " + th);
            }
        }
        return false;
    }
}

