/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.troubleshoot;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConfig;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiagnosticInfoCollector {
    private AgentLogger logger;
    private static final String SEPARATOR = "========================================================================";

    public DiagnosticInfoCollector() {
        try {
            this.logger = LoggingConfig.DIAGNOSTIC_LOGGER.getLogger();
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Unable to get diagnostics logger");
            this.logger = JavaAgent.logger;
        }
        this.logger.info("\t\tJavaAgent Diagnostics Information - " + new Date(System.currentTimeMillis()).toString() + "\n" + SEPARATOR);
    }

    public void collectInfo() {
        this.getEnvironment();
        this.getFilesOnClasspath();
        this.getAllLoadedClassesInfo();
    }

    private void getAllJMXValues() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> mBeans = mBeanServer.queryNames(null, null);
        for (ObjectName mBean : mBeans) {
            try {
                MBeanInfo beanInfo = mBeanServer.getMBeanInfo(mBean);
                MBeanAttributeInfo[] attributeInfo = beanInfo.getAttributes();
                this.logger.info(">>>" + mBean);
                for (MBeanAttributeInfo info : attributeInfo) {
                    try {
                        Object attr = mBeanServer.getAttribute(mBean, info.getName());
                        this.logger.info(info.getName() + "=" + attr);
                        if (!attr.getClass().isArray()) continue;
                        this.logger.info("****" + Arrays.deepToString((Object[])attr));
                    }
                    catch (Exception e) {
                        this.logger.warn("Error occured in getting attribute " + info.getName());
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Error occurec in getting bean info. " + mBean);
            }
            this.logger.info("================================");
        }
    }

    private void getAllLoadedClassesInfo() {
        Object[] allClz = JavaAgent.getInstance().getInstrumentation().getAllLoadedClasses();
        HashSet<URL> location = new HashSet<URL>();
        for (Class clazz : allClz) {
            try {
                if (clazz.getName().startsWith("java")) continue;
                location.add(clazz.getProtectionDomain().getCodeSource().getLocation());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.printInfo("All classes", Arrays.deepToString(allClz));
        this.printInfo("Class Jars", ((Object)location).toString());
    }

    private void printInfo(String key, String value) {
        this.logger.info("\n" + key + "\n************************");
        this.logger.info(value);
        this.logger.info(SEPARATOR);
    }

    private void getEnvironment() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            if (runtimeMXBean.isBootClassPathSupported()) {
                this.printInfo("Boot Classpath", runtimeMXBean.getBootClassPath());
            }
            this.printInfo("Classpath", runtimeMXBean.getClassPath());
            this.printInfo("Library Path", runtimeMXBean.getLibraryPath());
            this.printInfo("Java Arguments", runtimeMXBean.getInputArguments().toString());
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Diagnostics - Failed to get runtime information.", th);
        }
    }

    private void getFilesOnClasspath() {
        try {
            URL[] urls;
            StringBuilder sb = new StringBuilder();
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                sb.append(url.getFile() + "\n");
            }
            this.printInfo("Boot Classpath Jars", sb.toString());
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Diagnostics - Failed to get classpath information.", th);
        }
    }
}

