/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnvironmentUtil {
    public static List<File> getAllJarsInEnv() {
        String paths = "";
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        paths = paths + runtimeMXBean.getClassPath();
        if (runtimeMXBean.isBootClassPathSupported()) {
            paths = paths + File.pathSeparator + runtimeMXBean.getBootClassPath();
        }
        paths = paths + File.pathSeparator + runtimeMXBean.getLibraryPath();
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String path : paths.split(File.pathSeparator)) {
            File[] jars;
            File file = new File(path);
            if (path.endsWith(".jar")) {
                jarFiles.add(file);
            }
            if (!file.isDirectory() || (jars = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".*.jar");
                }
            })) == null) continue;
            jarFiles.addAll(Arrays.asList(jars));
        }
        return jarFiles;
    }
}

