/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static final int FILEBUFSIZE = 128;
    private static FileUtil fSingleton;

    public static synchronized FileUtil getInstance() {
        if (fSingleton == null) {
            fSingleton = new FileUtil();
        }
        return fSingleton;
    }

    public String readCharacterFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("supplied filename to FileUtil was null");
        }
        return this.readCharacterFile(new FileReader(fileName));
    }

    public String readCharacterFile(File theFile) throws IOException {
        if (theFile == null) {
            throw new IllegalArgumentException("supplied File object to FileUtil was null");
        }
        return this.readCharacterFile(new FileReader(theFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readCharacterFile(Reader theReader) throws IOException {
        if (theReader == null) {
            throw new IllegalArgumentException("supplied Reader object to FileUtil was null");
        }
        StringWriter sw = new StringWriter();
        try {
            int n;
            char[] text = new char[128];
            while ((n = theReader.read(text, 0, 128)) > 0) {
                sw.write(text, 0, n);
            }
        }
        finally {
            if (theReader != null) {
                theReader.close();
            }
        }
        return sw.toString();
    }

    public String readCharacterFile(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("supplied InputStream object to FileUtil was null");
        }
        try {
            String string = this.readCharacterFile(new InputStreamReader(inputStream));
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void writeCharacterFile(String fileName, String contents) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("Supplied filename to FileUtil was null");
        }
        this.writeCharacterFile(new FileWriter(fileName), contents);
    }

    public void writeCharacterFile(File file, String contents) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Supplied File object to FileUtil was null");
        }
        this.writeCharacterFile(new FileWriter(file), contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCharacterFile(Writer fileWriter, String contents) throws IOException {
        if (fileWriter == null) {
            throw new IllegalArgumentException("supplied FileWriter to FileUtil was null");
        }
        try {
            int n;
            StringReader sr = new StringReader(contents);
            char[] text = new char[128];
            while ((n = sr.read(text, 0, 128)) > 0) {
                fileWriter.write(text, 0, n);
            }
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public void createDirectory(String name) throws Exception {
        try {
            File f = new File(name);
            if (!f.exists()) {
                f.mkdir();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create the directory '" + name + "' Check read write permisions for the directory.", ex);
        }
    }

    public static void deleteDirectory(String name) throws IOException {
        if (name == null) {
            throw new IOException("Directory path to be deleted can't be null");
        }
        FileUtil.deleteDirectory(new File(name));
    }

    public static void deleteDirectory(File dirName) throws IOException {
        if (dirName == null) {
            throw new IOException("Directory name to be deleted can't be null");
        }
        FileUtil.cleanDirectory(dirName);
        if (dirName.exists() && !dirName.delete()) {
            throw new IOException("Unable to delete the directory: " + dirName);
        }
    }

    public static void cleanDirectory(File cleanDir) throws IOException {
        File[] innerFilesAndFolders;
        if (cleanDir.isDirectory() && (innerFilesAndFolders = cleanDir.listFiles()) != null) {
            for (File innerFileOrFolder : innerFilesAndFolders) {
                if (innerFileOrFolder.isDirectory()) {
                    FileUtil.deleteDirectory(innerFileOrFolder.getPath());
                    continue;
                }
                innerFileOrFolder.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File outputDir) throws IOException {
        if (zipFile == null || outputDir == null) {
            return;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            File unzipedEntry = new File(outputDir.getAbsolutePath() + File.separator + zipEntry.getName());
            new File(unzipedEntry.getParent()).mkdirs();
            try (FileOutputStream fos = new FileOutputStream(unzipedEntry);){
                int c;
                byte[] buff = new byte[1024];
                while ((c = zipInputStream.read(buff)) > 0) {
                    fos.write(buff, 0, c);
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
    }

    public static void refillPropertiesFile(File propertiesFile, final Map keyValuesToBeRefilledIn, boolean appendNoMatchKeyValues) throws IOException {
        String line;
        HashMap<String, String> keyValuesToRefill = new HashMap<String, String>(){
            {
                this.putAll(keyValuesToBeRefilledIn);
            }

            @Override
            public String get(Object key) {
                String v = (String)super.get(key);
                if (v != null) {
                    this.remove(key);
                }
                return v;
            }
        };
        BufferedReader br = new BufferedReader(new FileReader(propertiesFile));
        StringBuffer fileContent = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) {
                fileContent.append(line);
            } else {
                String[] keyValue = (line = line + " ").split("=");
                if (keyValue.length == 1) {
                    keyValue = line.split(":");
                }
                if (keyValue.length == 1) {
                    fileContent.append(line.trim());
                } else {
                    String key = keyValue[0].trim();
                    fileContent.append(key);
                    fileContent.append('=');
                    String value = (String)keyValuesToRefill.get(key);
                    fileContent.append(value == null ? keyValue[1].trim() : value);
                }
            }
            fileContent.append('\n');
        }
        br.close();
        if (appendNoMatchKeyValues) {
            for (Map.Entry entry : keyValuesToRefill.entrySet()) {
                fileContent.append('\n');
                fileContent.append((String)entry.getKey());
                fileContent.append('=');
                fileContent.append((String)entry.getValue());
            }
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(propertiesFile));
        out.write(fileContent.toString());
        out.close();
    }

    public static void fileCopy(File sourceDir, String sourceFileName, File destDir, String newFileName) throws IOException {
        FileUtil.fileCopy(new File(sourceDir, sourceFileName), new File(destDir, newFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File source, File dest) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath() + " not exists!");
        }
        File destParentDir = dest.getParentFile();
        if (destParentDir != null && !destParentDir.exists()) {
            dest.mkdirs();
        }
        destParentDir = null;
        if (!dest.exists()) {
            dest.createNewFile();
        }
        if (!dest.canWrite()) {
            throw new IOException("write permission disabled for dest: " + dest.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        try {
            byte[] buffer = new byte[4096];
            int lengthRead = 0;
            while ((lengthRead = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, lengthRead);
            }
        }
        finally {
            fis.close();
            fos.close();
        }
    }

    public static void changePermissions(File fileName) throws SecurityException {
        fileName.setReadable(false, false);
        fileName.setWritable(false, false);
        fileName.setExecutable(false, false);
        fileName.setReadable(true, true);
        fileName.setWritable(true, true);
    }

    public static void changePermissions(String fileName) throws SecurityException {
        FileUtil.changePermissions(new File(fileName));
    }
}

