/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtil {
    public static String getJarVersionFromUrl(URL jarUrl) {
        try {
            Manifest manifest = null;
            String type = jarUrl.getProtocol();
            if (type.equals("jar")) {
                JarURLConnection jarCon = (JarURLConnection)jarUrl.openConnection();
                manifest = jarCon.getManifest();
            } else {
                JarFile jar = new JarFile(new File(jarUrl.toURI()));
                manifest = jar.getManifest();
            }
            return JarUtil.getJarVersionFromManifestAttributes(manifest.getMainAttributes());
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static String getJarVersionFromManifestAttributes(Attributes attributes) {
        String version = attributes.getValue("Implementation-Version");
        return version == null ? attributes.getValue("Bundle-Version") : version;
    }
}

