/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import com.manageengine.apminsight.agent.DataCenter;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.SecurityUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import java.io.File;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAgentUtil {
    private static final String AGENT_PREMAIN_CLASS_NAME = JavaAgent.class.getCanonicalName().replace('.', '/') + ".class";
    private static final Pattern AGENT_JAR_URL_PATTERN = Pattern.compile("^jar:(.*)!/" + AGENT_PREMAIN_CLASS_NAME + '$');
    private static final PrintStream ERR_STREAM = System.err;

    public static void print(String text) {
        try {
            JavaAgentUtil.getDefaultPrintStream().println(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToErrStream(String msg) {
        ERR_STREAM.println(msg);
    }

    public static PrintStream getDefaultPrintStream() {
        return System.out;
    }

    public static File getAgentInstallDirectory() throws RuntimeException {
        String home = System.getProperty("apminsight.home");
        if (home != null) {
            return new File(home);
        }
        File agentInstallDir = JavaAgentUtil.getAgentJarDirPath();
        if (agentInstallDir != null) {
            home = agentInstallDir.getAbsolutePath();
            System.setProperty("apminsight.home", home);
            return agentInstallDir;
        }
        return null;
    }

    public static File getAgentJarDirPath() throws RuntimeException {
        try {
            File file;
            URL agentJarUrl = JavaAgentUtil.getAgentJarUrl();
            if (agentJarUrl != null && (file = new File(new URI(agentJarUrl.toExternalForm()))).exists()) {
                File parentFile = file.getParentFile();
                return parentFile;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static URL getAgentJarUrl() throws RuntimeException {
        try {
            Matcher matcher;
            URL resourceURL = ClassLoader.getSystemResource(AGENT_PREMAIN_CLASS_NAME);
            if (resourceURL != null && (matcher = AGENT_JAR_URL_PATTERN.matcher(resourceURL.toExternalForm())).matches()) {
                return new URL(matcher.group(1));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String listToString(List list) {
        StringBuffer s = new StringBuffer("[");
        for (Object o : list) {
            if (o instanceof Object[]) {
                s.append(Arrays.deepToString((Object[])o));
            } else {
                s.append(o.toString());
            }
            s.append(", ");
        }
        String toString = s.toString();
        if (toString.length() > 1) {
            toString = toString.substring(0, toString.length() - 2);
        }
        toString = toString + "]";
        return toString;
    }

    public static long convertBytesToMB(long bytes) {
        if (bytes <= 0L) {
            return 0L;
        }
        return bytes / 0x100000L;
    }

    public static String getJvmProcessId() {
        String pid = "unknownPID";
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            pid = name.split("@")[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pid;
    }

    public static StackTraceElement[] getStackTrace(int skipInitialLines, int maxLength) {
        try {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            if (st.length <= skipInitialLines) {
                return st;
            }
            int length = st.length - skipInitialLines;
            length = length > maxLength ? maxLength : length;
            StackTraceElement[] paredSt = new StackTraceElement[length];
            System.arraycopy(st, skipInitialLines - 1, paredSt, 0, length);
            return paredSt;
        }
        catch (Exception e) {
            JavaAgent.logger.warn("JavaAgentUtil getStackTrace. " + e.getMessage());
            return null;
        }
    }

    public static boolean isJvmVersion15() {
        String jvmVersion = System.getProperty("java.version");
        return !StringUtils.isEmptyString(jvmVersion) && jvmVersion.startsWith("1.5");
    }

    public static boolean isIBMJava() {
        String jvmName = System.getProperty("java.vm.name");
        return !StringUtils.isEmptyString(jvmName) && jvmName.startsWith("IBM");
    }

    public static DataCenter getDataCenter(String licenseKey) {
        if (licenseKey == null) {
            return DataCenter.US;
        }
        return licenseKey.startsWith("eu_") ? DataCenter.EU : (licenseKey.startsWith("cn_") ? DataCenter.CN : (licenseKey.startsWith("in_") ? DataCenter.IN : (licenseKey.startsWith("au_") ? DataCenter.AU : (licenseKey.startsWith("jp_") ? DataCenter.JP : DataCenter.US))));
    }

    public static void encryptSensitiveData(File confFile) throws Exception {
        Properties configProps = Utils.getContentAsProps(confFile);
        String licenseKey = configProps.getProperty("license.key");
        try {
            licenseKey = SecurityUtil.decryptString(licenseKey, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> keysToEncrypt = new HashMap<String, String>();
        keysToEncrypt.put("license.key", null);
        keysToEncrypt.put("proxy.auth.password", licenseKey);
        for (Map.Entry keyToEncrypt : keysToEncrypt.entrySet()) {
            String value = configProps.getProperty((String)keyToEncrypt.getKey());
            String secretKey = (String)keyToEncrypt.getValue();
            if (StringUtils.isEmptyString(value)) continue;
            try {
                SecurityUtil.decryptString(value, secretKey);
            }
            catch (Exception e) {
                configProps.setProperty((String)keyToEncrypt.getKey(), SecurityUtil.encryptString(value, secretKey));
            }
        }
        FileUtil.refillPropertiesFile(confFile, configProps, true);
    }
}

