/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.vm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadInfoCapture {
    public static final int CPU = 1;
    public static final int WAIT = 2;
    public static final int BLOCK = 4;
    private static boolean threadContentionMonitoringEnabled = false;
    private static boolean threadCPUTimeEnabled = false;
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    protected int metricOption = 7;
    protected long elapsedTime = 0L;
    protected long totalCpuTime = 0L;
    protected long blockedCount = 0L;
    protected long blockedTime = 0L;
    protected long waitCount = 0L;
    protected long waitTime = 0L;
    public static ThreadLocal<ThreadInfoCapture> threadInfoLocal = new ThreadLocal();

    protected ThreadInfoCapture() {
    }

    protected ThreadInfoCapture(int options) {
        this.metricOption = options;
        this.elapsedTime = System.currentTimeMillis();
        if (this.metricOption < 0) {
            return;
        }
        if (threadCPUTimeEnabled && (this.metricOption & 1) == 1) {
            this.totalCpuTime = threadMXBean.getCurrentThreadCpuTime();
        }
        if (threadContentionMonitoringEnabled) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(Thread.currentThread().getId());
            if ((this.metricOption & 4) == 4) {
                this.blockedCount = threadInfo.getBlockedCount();
                this.blockedTime = threadInfo.getBlockedTime();
            }
            if ((this.metricOption & 2) == 2) {
                this.waitCount = threadInfo.getWaitedCount();
                this.waitTime = threadInfo.getWaitedTime();
            }
        }
    }

    public static void start() {
        ThreadInfoCapture.start(7);
    }

    public static void start(int options) {
        threadInfoLocal.set(new ThreadInfoCapture(options));
    }

    public static ThreadInfoCapture end() {
        ThreadInfoCapture snapshot = threadInfoLocal.get();
        if (snapshot == null) {
            return null;
        }
        int metricOption = snapshot.metricOption;
        ThreadInfoCapture tic = new ThreadInfoCapture(metricOption);
        tic.elapsedTime = System.currentTimeMillis() - snapshot.elapsedTime;
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(Thread.currentThread().getId());
        if (threadCPUTimeEnabled && (metricOption & 1) == 1) {
            tic.totalCpuTime = threadMXBean.getCurrentThreadCpuTime() - snapshot.totalCpuTime;
            tic.totalCpuTime /= 1000L;
        }
        if (threadContentionMonitoringEnabled) {
            if ((metricOption & 4) == 4) {
                tic.blockedCount = threadInfo.getBlockedCount() - snapshot.blockedCount;
                tic.blockedTime = threadInfo.getBlockedTime() - snapshot.blockedTime;
            }
            if ((metricOption & 2) == 2) {
                tic.waitCount = threadInfo.getWaitedCount() - snapshot.waitCount;
                tic.waitTime = threadInfo.getWaitedTime() - snapshot.waitTime;
            }
        }
        return tic;
    }

    public boolean isThreadContentionMonitoringEnabled() {
        return threadContentionMonitoringEnabled;
    }

    public boolean isThreadCPUTimeEnabled() {
        return threadCPUTimeEnabled;
    }

    public void setThreadContentionMonitoringEnabled(boolean threadContentionMonitoringEnabled) {
        ThreadInfoCapture.threadContentionMonitoringEnabled = threadContentionMonitoringEnabled;
    }

    public void setThreadCPUTimeEnabled(boolean threadCPUTimeEnabled) {
        ThreadInfoCapture.threadCPUTimeEnabled = threadCPUTimeEnabled;
    }

    public void traceMetric(String nameSpace) {
    }

    public String getMetricName(String segment) {
        StringBuilder sb = new StringBuilder("ThreadInfo");
        sb.append("/").append(segment);
        return sb.toString();
    }

    static {
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            threadMXBean.setThreadCpuTimeEnabled(true);
            threadCPUTimeEnabled = true;
        }
        if (threadMXBean.isThreadContentionMonitoringSupported()) {
            threadMXBean.setThreadContentionMonitoringEnabled(true);
            threadContentionMonitoringEnabled = true;
        }
    }
}

