/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.apache.hc.core5.http.protocol;

import com.manageengine.org.apache.hc.core5.annotation.Contract;
import com.manageengine.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.manageengine.org.apache.hc.core5.http.EntityDetails;
import com.manageengine.org.apache.hc.core5.http.HttpException;
import com.manageengine.org.apache.hc.core5.http.HttpRequest;
import com.manageengine.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.manageengine.org.apache.hc.core5.http.HttpVersion;
import com.manageengine.org.apache.hc.core5.http.ProtocolVersion;
import com.manageengine.org.apache.hc.core5.http.protocol.HttpContext;
import com.manageengine.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

