/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.crypto.prng;

import com.manageengine.org.bouncycastle.crypto.prng.EntropySource;
import com.manageengine.org.bouncycastle.crypto.prng.EntropySourceProvider;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    public EntropySource get(final int n) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                return BasicEntropySourceProvider.this._sr.generateSeed((n + 7) / 8);
            }

            public int entropySize() {
                return n;
            }
        };
    }
}

