/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.jcajce.provider.digest;

import com.manageengine.org.bouncycastle.crypto.CipherKeyGenerator;
import com.manageengine.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import com.manageengine.org.bouncycastle.crypto.macs.HMac;
import com.manageengine.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.manageengine.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.manageengine.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            this.addHMACAlgorithm(configurableProvider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

