/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util;

import com.manageengine.org.bouncycastle.crypto.CipherParameters;
import com.manageengine.org.bouncycastle.crypto.Mac;
import com.manageengine.org.bouncycastle.crypto.params.KeyParameter;
import com.manageengine.org.bouncycastle.crypto.params.ParametersWithIV;
import com.manageengine.org.bouncycastle.crypto.params.SkeinParameters;
import com.manageengine.org.bouncycastle.jcajce.PKCS12Key;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.manageengine.org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.manageengine.org.bouncycastle.jcajce.spec.SkeinParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class BaseMac
extends MacSpi
implements PBE {
    private Mac macEngine;
    private int scheme = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected BaseMac(Mac mac) {
        this.macEngine = mac;
    }

    protected BaseMac(Mac mac, int n, int n2, int n3) {
        this.macEngine = mac;
        this.scheme = n;
        this.pbeHash = n2;
        this.keySize = n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof PKCS12Key) {
            PBEParameterSpec pBEParameterSpec;
            SecretKey secretKey;
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            try {
                pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("PKCS12 requires a PBEParameterSpec");
            }
            if (secretKey instanceof PBEKey && pBEParameterSpec == null) {
                pBEParameterSpec = new PBEParameterSpec(((PBEKey)secretKey).getSalt(), ((PBEKey)secretKey).getIterationCount());
            }
            int n = 1;
            int n2 = 160;
            if (this.macEngine.getAlgorithmName().startsWith("GOST")) {
                n = 6;
                n2 = 256;
            } else if (this.macEngine.getAlgorithmName().startsWith("SHA256")) {
                n = 4;
                n2 = 256;
            }
            cipherParameters = PBE.Util.makePBEMacParameters(secretKey, 2, n, n2, pBEParameterSpec);
        } else if (key instanceof BCPBEKey) {
            BCPBEKey bCPBEKey = (BCPBEKey)key;
            if (bCPBEKey.getParam() != null) {
                cipherParameters = bCPBEKey.getParam();
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                cipherParameters = PBE.Util.makePBEMacParameters(bCPBEKey, algorithmParameterSpec);
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            cipherParameters = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)algorithmParameterSpec).getIV());
        } else if (algorithmParameterSpec instanceof SkeinParameterSpec) {
            cipherParameters = new SkeinParameters.Builder(BaseMac.copyMap(((SkeinParameterSpec)algorithmParameterSpec).getParameters())).setKey(key.getEncoded()).build();
        } else {
            if (algorithmParameterSpec != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            cipherParameters = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(cipherParameters);
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte by) {
        this.macEngine.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.macEngine.update(byArray, n, n2);
    }

    protected byte[] engineDoFinal() {
        byte[] byArray = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(byArray, 0);
        return byArray;
    }

    private static Hashtable copyMap(Map map) {
        Hashtable hashtable = new Hashtable();
        for (Object k : map.keySet()) {
            hashtable.put(k, map.get(k));
        }
        return hashtable;
    }
}

