/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.jce;

import com.manageengine.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.manageengine.org.bouncycastle.asn1.x9.X9ECParameters;
import com.manageengine.org.bouncycastle.crypto.ec.CustomNamedCurves;
import com.manageengine.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import java.util.Enumeration;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String string) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null) {
            try {
                x9ECParameters = CustomNamedCurves.getByOID(new ASN1ObjectIdentifier(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (x9ECParameters == null && (x9ECParameters = com.manageengine.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByName(string)) == null) {
                try {
                    x9ECParameters = com.manageengine.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (x9ECParameters == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(string, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public static Enumeration getNames() {
        return com.manageengine.org.bouncycastle.asn1.x9.ECNamedCurveTable.getNames();
    }
}

