/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.math.ec.custom.sec;

import com.manageengine.org.bouncycastle.math.ec.ECConstants;
import com.manageengine.org.bouncycastle.math.ec.ECCurve;
import com.manageengine.org.bouncycastle.math.ec.ECFieldElement;
import com.manageengine.org.bouncycastle.math.ec.ECMultiplier;
import com.manageengine.org.bouncycastle.math.ec.ECPoint;
import com.manageengine.org.bouncycastle.math.ec.WTauNafMultiplier;
import com.manageengine.org.bouncycastle.math.ec.custom.sec.SecT283FieldElement;
import com.manageengine.org.bouncycastle.math.ec.custom.sec.SecT283K1Point;
import com.manageengine.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Random;

public class SecT283K1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT283K1_DEFAULT_COORDS = 6;
    protected SecT283K1Point infinity = new SecT283K1Point(this, null, null);

    public SecT283K1Curve() {
        super(283, 5, 7, 12);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE9AE2ED07577265DFF7F94451E061E163C61"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT283K1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    public int getFieldSize() {
        return 283;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT283FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecT283K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecT283K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return true;
    }

    protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
        ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.isZero()) {
            eCFieldElement2 = this.b.sqrt();
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.b).add(this.a).add(eCFieldElement);
            ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
            if (eCFieldElement4 != null) {
                if (eCFieldElement4.testBitZero() != (n == 1)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                        break;
                    }
                    default: {
                        eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                    }
                }
            }
        }
        if (eCFieldElement2 == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(eCFieldElement, eCFieldElement2, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random = new Random();
        do {
            ECFieldElement eCFieldElement5 = this.fromBigInteger(new BigInteger(283, random));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i = 1; i < 283; ++i) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public int getM() {
        return 283;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }
}

