/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.pqc.asn1;

import com.manageengine.org.bouncycastle.asn1.ASN1EncodableVector;
import com.manageengine.org.bouncycastle.asn1.ASN1Integer;
import com.manageengine.org.bouncycastle.asn1.ASN1Object;
import com.manageengine.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.manageengine.org.bouncycastle.asn1.ASN1OctetString;
import com.manageengine.org.bouncycastle.asn1.ASN1Primitive;
import com.manageengine.org.bouncycastle.asn1.ASN1Sequence;
import com.manageengine.org.bouncycastle.asn1.DEROctetString;
import com.manageengine.org.bouncycastle.asn1.DERSequence;
import com.manageengine.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McElieceCCA2PublicKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int t;
    private byte[] matrixG;

    public McElieceCCA2PublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, int n2, GF2Matrix gF2Matrix) {
        this.oid = aSN1ObjectIdentifier;
        this.n = n;
        this.t = n2;
        this.matrixG = gF2Matrix.getEncoded();
    }

    private McElieceCCA2PublicKey(ASN1Sequence aSN1Sequence) {
        this.oid = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.n = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
        this.t = bigInteger2.intValue();
        this.matrixG = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.matrixG);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.oid);
        aSN1EncodableVector.add(new ASN1Integer(this.n));
        aSN1EncodableVector.add(new ASN1Integer(this.t));
        aSN1EncodableVector.add(new DEROctetString(this.matrixG));
        return new DERSequence(aSN1EncodableVector);
    }

    public static McElieceCCA2PublicKey getInstance(Object object) {
        if (object instanceof McElieceCCA2PublicKey) {
            return (McElieceCCA2PublicKey)object;
        }
        if (object != null) {
            return new McElieceCCA2PublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

