/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent;

import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.installer.AppServer;
import com.manageengine.apminsight.agent.installer.AppServerIdentifier;
import com.manageengine.apminsight.agent.troubleshoot.AgentTroubleshooter;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.commons.cli.CommandLine;
import com.manageengine.org.apache.commons.cli.DefaultParser;
import com.manageengine.org.apache.commons.cli.HelpFormatter;
import com.manageengine.org.apache.commons.cli.Option;
import com.manageengine.org.apache.commons.cli.Options;
import com.manageengine.org.apache.commons.cli.ParseException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class CommandLineArgsParser {
    private static final String CMDLINE_SYNTAX_PREFIX = "java -jar apminsight-javaagent.jar ";
    private static final String INSTALL_OPERATION = "install";
    private static final String TROUBLESHOOT_OPERATION = "troubleshoot";
    private static final String FILE_SEPARATOR = File.separator;
    private static final Map<String, Options> OPERATIONS = new HashMap<String, Options>();
    private static final Map<String, String> OPERATION_DESCRIPTION;

    public void parse(String[] args) {
        block13: {
            try {
                String operation;
                DefaultParser parser = new DefaultParser();
                CommandLine cmdLine = parser.parse(CommandLineArgsParser.getAllOptions(), args);
                List<String> argsList = cmdLine.getArgList();
                String string = operation = argsList.size() > 0 ? argsList.get(0) : null;
                if (cmdLine.hasOption('h')) {
                    this.printHelp(operation);
                    break block13;
                }
                if (cmdLine.hasOption('v')) {
                    this.printAgentVersion();
                    break block13;
                }
                if (cmdLine.hasOption("start")) {
                    this.attachAgent(cmdLine.getOptionValue("start"));
                    break block13;
                }
                if (operation != null) {
                    String agentDir;
                    Options options = OPERATIONS.get(operation);
                    if (options == null) {
                        this.printHelp(operation);
                        return;
                    }
                    try {
                        agentDir = new File(this.getAgentPath()).getParent();
                    }
                    catch (Throwable th) {
                        agentDir = new File("").getAbsolutePath();
                    }
                    agentDir = agentDir.replaceAll("\\\\", "/");
                    cmdLine = parser.parse(options, args);
                    if (operation.equals(INSTALL_OPERATION)) {
                        this.installAgent(cmdLine, agentDir);
                    } else if (operation.equals(TROUBLESHOOT_OPERATION)) {
                        this.troubleshootAgent(cmdLine, agentDir);
                    }
                    break block13;
                }
                JavaAgentUtil.print("Invalid Option...");
                this.printHelp();
            }
            catch (ParseException e) {
                JavaAgentUtil.print("Error parsing arguments...");
                this.printHelp();
            }
            catch (Throwable th) {
                JavaAgentUtil.print("Invalid arguments...");
                this.printHelp();
            }
        }
    }

    private void installAgent(CommandLine cmdLine, String agentDir) {
        JavaAgentUtil.print("\nInstalling APM Insight Java agent ...");
        String serverPath = agentDir;
        try {
            if (cmdLine.hasOption('p')) {
                File file = new File(cmdLine.getOptionValue('p'));
                if (file.exists() && file.isDirectory()) {
                    serverPath = file.getAbsolutePath();
                } else {
                    JavaAgentUtil.print("\nSpecified path is invalid. Proceeding with current working directory..");
                }
            }
            if (cmdLine.hasOption('k')) {
                HashMap<String, String> agentConfig = new HashMap<String, String>();
                agentConfig.put("license.key", cmdLine.getOptionValue('k'));
                FileUtil.refillPropertiesFile(new File(agentDir + FILE_SEPARATOR + "apminsight.conf"), agentConfig, false);
                JavaAgentUtil.print("\nLicense key written to apminsight.conf file.");
            }
            JavaAgentUtil.print("\nIdentifying the application server...");
            AppServer appServer = AppServerIdentifier.identify(serverPath);
            if (appServer == AppServer.UNKNOWN) {
                JavaAgentUtil.print("\nUnable to identify the application server at " + serverPath);
                this.printSupportHelp();
                return;
            }
            JavaAgentUtil.print("\nFound " + appServer.getServerName() + " server at provided path");
            boolean isSuccessfull = appServer.getInstaller(serverPath).installAgent(agentDir);
            try {
                Properties agentProps = Utils.getContentAsProps(new File(agentDir, "apminsight.conf"));
                String licenseKey = agentProps.getProperty("license.key");
                if (!StringUtils.isEmptyString(licenseKey)) {
                    JavaAgentUtil.encryptSensitiveData(new File(agentDir, "apminsight.conf"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isSuccessfull) {
                JavaAgentUtil.print("\nAgent installation completed successfully.");
                JavaAgentUtil.print("Restart your " + appServer.getServerName() + " server");
            } else {
                JavaAgentUtil.print("\nAgent installation failed.");
                this.printSupportHelp();
            }
        }
        catch (Throwable th) {
            JavaAgentUtil.print("\nError Occurred during installation. Quitting...\n" + th);
            JavaAgentUtil.print("Agent installation failed.");
            this.printSupportHelp();
        }
    }

    private void troubleshootAgent(CommandLine cmdLine, String agentDir) {
        boolean createDiagnostics = false;
        if (cmdLine.hasOption('c')) {
            createDiagnostics = true;
        }
        new AgentTroubleshooter(agentDir).troubleshoot(createDiagnostics);
    }

    private void printSupportHelp() {
        JavaAgentUtil.print("\nPlease visit our help page https://www.site24x7.com/help/apm/java-agent.html");
        JavaAgentUtil.print("Contact support@site24x7.com for further assitance.");
    }

    private void printHelp(String operation) {
        if (operation == null) {
            this.printHelp();
            return;
        }
        HelpFormatter help = new HelpFormatter();
        help.printHelp(CMDLINE_SYNTAX_PREFIX + operation + " [OPTIONS]", OPERATIONS.get(operation));
    }

    private void printHelp() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("java -jar apminsight-javaagent.jar [OPTIONS]", CommandLineArgsParser.getGeneralOptions());
        StringBuilder operationHelp = new StringBuilder();
        int maxLength = this.findMaxLengthOperation();
        int minSpaces = 3;
        for (String operation : OPERATIONS.keySet()) {
            char[] extraSpaces = new char[maxLength - operation.length() + minSpaces];
            Arrays.fill(extraSpaces, ' ');
            operationHelp.append("\n ");
            operationHelp.append(operation).append(extraSpaces).append(OPERATION_DESCRIPTION.get(operation));
        }
        JavaAgentUtil.print(operationHelp.toString());
    }

    private void printAgentVersion() {
        JavaAgentUtil.print("APM Insight Java Agent version: " + JavaAgentConfig.getAgentFullVersion());
    }

    private void attachAgent(String pid) {
        File toolsJar;
        String javaHome = System.getProperty("java.home");
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome + "/..";
        }
        if ((toolsJar = new File(javaHome + "/lib/tools.jar")).exists()) {
            this.addJarToClassPath(toolsJar);
        }
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(this.getAgentPath(), "");
            vm.detach();
            JavaAgentUtil.print("[JAVA AGENT] Agent loaded & VM detached");
        }
        catch (Exception e) {
            JavaAgentUtil.print("[JAVA AGENT] Unable to attach agent to PID " + pid + " Exception: " + e.getMessage());
        }
    }

    private void addJarToClassPath(File toolsJar) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), toolsJar.toURI().toURL());
        }
        catch (Exception e) {
            JavaAgentUtil.print("[JAVA AGENT] Unable add tools.jar to classpath");
        }
    }

    private String getAgentPath() {
        try {
            File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            JavaAgentUtil.print("[JAVA AGENT] Unable to get agent location");
            return null;
        }
    }

    private int findMaxLengthOperation() {
        int maxLength = 0;
        for (String operation : OPERATIONS.keySet()) {
            maxLength = Math.max(maxLength, operation.length());
        }
        return maxLength;
    }

    private static Options getGeneralOptions() {
        Options generalOptions = new Options();
        generalOptions.addOption("v", "version", false, "Displays APM Insight java agent version");
        generalOptions.addOption("h", "help", false, "Displays this help");
        generalOptions.addOption("start", true, "Start agent by attaching to the provided Java process ID");
        return generalOptions;
    }

    private static Options getInstallOptions() {
        Options installOptions = new Options();
        installOptions.addOption("h", "help", false, "Displays this help");
        installOptions.addOption("k", "key", true, "Uses specified license key");
        installOptions.addOption("p", "path", true, "Installs agent in application server located at the specified path");
        return installOptions;
    }

    private static Options getTroubleshootOptions() {
        Options troubleshootOptions = new Options();
        troubleshootOptions.addOption("h", "help", false, "Displays this help");
        troubleshootOptions.addOption("c", false, "Creates a diagnostics file, for detailed debugging");
        return troubleshootOptions;
    }

    private static Options getAllOptions() {
        Options allOptions = new Options();
        for (Options options : OPERATIONS.values()) {
            for (Option option : options.getOptions()) {
                allOptions.addOption(option);
            }
        }
        for (Option option : CommandLineArgsParser.getGeneralOptions().getOptions()) {
            allOptions.addOption(option);
        }
        return allOptions;
    }

    static {
        OPERATIONS.put(INSTALL_OPERATION, CommandLineArgsParser.getInstallOptions());
        OPERATIONS.put(TROUBLESHOOT_OPERATION, CommandLineArgsParser.getTroubleshootOptions());
        OPERATION_DESCRIPTION = new HashMap<String, String>();
        OPERATION_DESCRIPTION.put(INSTALL_OPERATION, "Installs the Java agent in the specified server directory");
        OPERATION_DESCRIPTION.put(TROUBLESHOOT_OPERATION, "Troubleshoots the agent installation and configurations");
    }
}

