/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent;

import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.tracing.TrackerService;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.org.apache.logging.log4j.Level;

public final class JavaAgentHandler {
    private JavaAgentConfig config;
    private TrackerService trackerService;
    public static ThreadLocal<Object> transformingBytes = new ThreadLocal();
    private static Object marker = new Object();

    JavaAgentHandler(JavaAgentConfig config, TrackerService trackerService) {
        this.config = config;
        this.trackerService = trackerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker invokeTracker(String pointCutName, String className, String methodName, String methodDesc, Object thisObj, Object[] args, String annotationAttributes) {
        if (transformingBytes.get() != null) {
            return null;
        }
        try {
            if (!this.config.agentVerified) {
                Tracker tracker = null;
                return tracker;
            }
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.listenBlockFlag == 1) {
                Tracker tracker = null;
                return tracker;
            }
            if (transformingBytes.get() != null || WorkerThreadFactory.getInstance().isAgentThread(Thread.currentThread().getName())) {
                Tracker tracker = null;
                return tracker;
            }
            transformingBytes.set(marker);
            Tracker tracker = this.trackerService.getTracker(pointCutName, className, methodName, thisObj, args, annotationAttributes);
            Tracker tracker2 = tracker = seqSpace.transformTracker(tracker);
            return tracker2;
        }
        catch (Throwable th) {
            this.config.getLogger().log(Level.WARN, "[JavaAgentHandler] Exception in invokeTracker", th);
            Tracker tracker = null;
            return tracker;
        }
        finally {
            transformingBytes.remove();
        }
    }

    public void exitTracker(Tracker tracker, Throwable th) {
        try {
            if (tracker != null) {
                tracker.quit(th);
                if (!(tracker instanceof VoidTracker)) {
                    SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
                    seqSpace.markSequenceAsErr(th);
                    seqSpace.cleanAndUpdate(tracker);
                }
            }
        }
        catch (Throwable ex) {
            this.config.getLogger().log(Level.WARN, "[JavaAgentHandler] Exception in exitTracker(Throwable)", ex);
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            seqSpace.cleanAndUpdateOnTrackerError(tracker);
        }
    }

    public void exitTracker(Tracker tracker, int opcode, Object returnValue) {
        try {
            if (tracker != null) {
                tracker.quit(opcode, returnValue);
                if (!(tracker instanceof VoidTracker)) {
                    SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
                    seqSpace.cleanAndUpdate(tracker);
                }
            }
        }
        catch (Throwable th) {
            this.config.getLogger().log(Level.WARN, "[JavaAgentHandler] Exception in exitTracker(normal)", th);
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            seqSpace.cleanAndUpdateOnTrackerError(tracker);
        }
    }
}

