/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.api;

import com.manageengine.apminsight.agent.JavaAgentAPIHandler;
import com.manageengine.apminsight.agent.trackers.Tracker;

public final class CustomTracker {
    private Tracker tracker;

    public CustomTracker(String name) {
        this(name, null);
    }

    public CustomTracker(String name, String componentName) {
        try {
            this.tracker = JavaAgentAPIHandler.startTracker(name, componentName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(Throwable throwable) {
        try {
            JavaAgentAPIHandler.stopTracker(this.tracker, throwable);
            this.tracker = null;
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void trackException(String message, Throwable throwable) {
        try {
            JavaAgentAPIHandler.handleException(System.currentTimeMillis(), message, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void trackException(Throwable throwable) {
        if (throwable != null) {
            CustomTracker.trackException(throwable.getMessage(), throwable);
        }
    }

    public static void addParameter(String key, Object value) {
        try {
            JavaAgentAPIHandler.addParameter(key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setTransactionName(String name) {
        try {
            JavaAgentAPIHandler.setTransactionName(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

