/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.config.BackgroundSequenceConfig;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.Map;

public class ApplicationConfig
implements JavaAgentConstants,
LoggingConstants {
    private AgentLogger logger;
    public boolean captureSql = SQL_CAPTURE_ENABLED_DV;
    private boolean removeQueryLiterals = SQL_CAPTURED_PARAMETRIZE_DV;
    private float sqlTraceT = SQL_STACKTRACE_THRESHOLD_DV.floatValue();
    private boolean isDTTrackingEnabled = true;
    private WebSequenceConfig webSeqConfig;
    private BackgroundSequenceConfig backgroundSeqConfig;
    public String excludeExceptionsRegex = "";

    public ApplicationConfig(Map<String, Object> agentConfig) {
        this.logger = JavaAgent.logger;
        this.init(agentConfig);
    }

    protected void init(Map<String, Object> agentConfig) throws RuntimeException {
        this.logger.info("Application config initializing..");
        Object tempVar = null;
        tempVar = agentConfig.get("sql.capture.enabled");
        this.captureSql = tempVar == null ? SQL_CAPTURE_ENABLED_DV : Boolean.parseBoolean(tempVar.toString());
        tempVar = agentConfig.get("transaction.trace.sql.parametrize");
        this.removeQueryLiterals = tempVar == null ? SQL_CAPTURED_PARAMETRIZE_DV : Boolean.parseBoolean(tempVar.toString());
        tempVar = agentConfig.get("transaction.trace.sql.stacktrace.threshold");
        if (tempVar == null) {
            this.sqlTraceT = SQL_STACKTRACE_THRESHOLD_DV.floatValue();
        } else {
            try {
                this.sqlTraceT = Float.parseFloat(tempVar.toString());
            }
            catch (Exception e) {
                this.sqlTraceT = SQL_STACKTRACE_THRESHOLD_DV.floatValue();
            }
        }
        tempVar = agentConfig.get("exceptions.ignore");
        if (!StringUtils.isEmptyString((String)tempVar)) {
            try {
                this.excludeExceptionsRegex = tempVar.toString().trim().replaceAll("\\s", "").replaceAll(",", ".*|") + ".*";
            }
            catch (Exception e) {
                this.excludeExceptionsRegex = tempVar.toString();
            }
            this.logger.info("Exceptions listed to ignore: " + this.excludeExceptionsRegex);
        }
        this.isDTTrackingEnabled = (tempVar = agentConfig.get("distributed.tracing.enabled")) == null ? true : Boolean.parseBoolean((String)tempVar);
        if (this.webSeqConfig == null) {
            this.webSeqConfig = new WebSequenceConfig(agentConfig);
        } else {
            this.webSeqConfig.reInitialize(agentConfig);
        }
        if (this.backgroundSeqConfig == null) {
            this.backgroundSeqConfig = new BackgroundSequenceConfig(agentConfig);
        } else {
            this.backgroundSeqConfig.reInitialize(agentConfig);
        }
    }

    public void reInitialize(Map<String, Object> agentConfig) {
        this.init(agentConfig);
    }

    public float getSqlTraceThreshold() {
        return this.sqlTraceT * 1000.0f;
    }

    public boolean shouldRemoveQueryLiterals() {
        return this.removeQueryLiterals;
    }

    public boolean isDistributedTracingEnabled() {
        return this.isDTTrackingEnabled;
    }

    public WebSequenceConfig getWebSeqConfig() {
        return this.webSeqConfig;
    }

    public BackgroundSequenceConfig getBackgroundSeqConfig() {
        return this.backgroundSeqConfig;
    }
}

