/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.config.AbstractSequenceConfig;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Map;

public class BackgroundSequenceConfig
extends AbstractSequenceConfig {
    public BackgroundSequenceConfig(Map<String, Object> bgSequenceConfig) {
        super(bgSequenceConfig);
        this.init(bgSequenceConfig);
    }

    @Override
    protected void init(Map<String, Object> bgSequenceConfig) {
        this.logger.info("BackgroundSequenceConfig initializing.");
        this.isTrackingEnabled = true;
        Object tempVar = bgSequenceConfig.get("bgtransaction.tracking.enabled");
        if (tempVar != null) {
            this.isTrackingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.trace.enabled")) != null) {
            this.isTraceEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.trace.threshold")) != null) {
            try {
                this.traceThreshold = Float.parseFloat(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "bgtransaction.trace.threshold", Float.valueOf(this.traceThreshold));
            }
        }
        if ((tempVar = bgSequenceConfig.get("transaction.trace.duplicate")) != null) {
            this.traceDuplicate = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.tracking.request.interval")) != null) {
            try {
                this.samplingFactor = Short.parseShort(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "bgtransaction.tracking.request.interval", this.samplingFactor);
            }
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.tracker.drop.threshold")) != null) {
            try {
                this.trackerDropThreshold = Short.parseShort(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "bgtransaction.tracker.drop.threshold", this.trackerDropThreshold);
            }
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.record.cputime.enabled")) != null) {
            this.isTransactionCpuTimeEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.trace.external.components.count.threshold")) != null) {
            try {
                this.traceAfterExternalComponentCount = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "bgtransaction.trace.external.components.count.threshold", this.traceAfterExternalComponentCount);
            }
        }
        if ((tempVar = bgSequenceConfig.get("bgtransaction.record.memory.allocation.enabled")) != null) {
            this.isTransactionMemoryAllocEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        this.logger.info("BackgroundSequenceConfig initialized.");
    }

    @Override
    public boolean canTraceDuplicate() {
        return this.traceDuplicate;
    }
}

