/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InterestedMethodsStore {
    private Map<String, List<String>> store = null;
    private static final Pattern INPUT_SYNTAX = Pattern.compile("([a-zA-Z_](\\w)*(\\/[a-zA-Z_](\\w)*)*):((([a-zA-Z_](\\w)*))(\\,[a-zA-Z_](\\w)*)*)?");
    private static final List<String> ALL_METHODS = Collections.emptyList();

    InterestedMethodsStore(String initSource) {
        this.initialize(initSource);
    }

    public void reinitialize(String initSource) {
        this.initialize(initSource);
    }

    private void initialize(String initSource) {
        if (StringUtils.isEmptyString(initSource)) {
            throw new IllegalArgumentException("invalid initialize param");
        }
        String[] fragments = initSource.split(";");
        HashMap<String, List<String>> tempStore = new HashMap<String, List<String>>(fragments.length);
        for (String entry : fragments) {
            Matcher m = INPUT_SYNTAX.matcher(entry);
            if (!m.matches()) continue;
            String className = m.group(1);
            String methodNames = m.group(5);
            if (!StringUtils.isEmptyString(methodNames)) {
                List<String> methNames = Arrays.asList(methodNames.split(","));
                tempStore.put(className, methNames);
                continue;
            }
            tempStore.put(className, ALL_METHODS);
        }
        this.store = tempStore;
    }

    public final boolean isExists(String className, String methodName) {
        List<String> methodNames = this.store.get(className);
        if (methodNames == null) {
            return false;
        }
        if (ALL_METHODS == methodNames) {
            return true;
        }
        return methodNames.contains(methodName);
    }

    public void clean() {
        this.store.clear();
        JavaAgent.logger.info("InterestedMethodsStore cleaned successfully");
    }

    public int getOccupiedSize() {
        return this.store.size();
    }

    public int getSize() {
        return this.store.size();
    }

    public void destroy() {
        this.store = null;
        JavaAgent.logger.info("InterestedMethodsStore destroyed successfully");
    }

    protected void finalize() {
    }

    public String toString() {
        return this.store.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone not supported for this store.");
    }

    public static void main(String[] args) {
        InterestedMethodsStore i = new InterestedMethodsStore("com/xcompany/xproject/xmodule/DataCollector:doWork,checkTask;summa_dummy_hehehe");
    }
}

