/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.DataCenter;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.communication.ProxyConfig;
import com.manageengine.apminsight.agent.config.AgentConfigListener;
import com.manageengine.apminsight.agent.config.AgentDebugModeConfig;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.context.ContextNameChanger;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.instrumentation.InstrumentationFilter;
import com.manageengine.apminsight.agent.jvm.EnvironmentIdentifier;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.AgentLoggingInitializer;
import com.manageengine.apminsight.agent.logging.LoggingConfig;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByName;
import com.manageengine.apminsight.agent.sequence.SequenceNameChanger;
import com.manageengine.apminsight.agent.service.VulnerableJarVersionCollector;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.HostNameUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.LRUMap;
import com.manageengine.apminsight.agent.util.SecurityUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JavaAgentConfig
implements JavaAgentConstants,
LoggingConstants {
    public static final String AGENT_MAJOR_VERSION = "6.0";
    public static final String AGENT_MINOR_VERSION = "1";
    private File agentInstallDir;
    AgentLogger logger;
    private LoggingConfig loggingConfig;
    private ContextInfoManager contextManager;
    private boolean isContextMonitoringEnabled;
    public volatile boolean agentVerified;
    private int agentPollingInterval = 60;
    private long lastKnownAgentShutdownTime;
    private String applicationName;
    private String licenseKey;
    private String apmHost;
    private boolean isBehindProxy;
    private static DataCenter dataCenter = DataCenter.US;
    private int agentServerPort;
    public boolean isKnownDispatcher = false;
    private Map<String, Object> additionalAgentConfig = new HashMap<String, Object>();
    private Map<String, Object> agentUserConfig = new HashMap<String, Object>();
    public boolean captureSqlByReflection;
    private byte printStatistics;
    private int trackerStoreSize;
    private static final String APMINSIGHT_PKG = "com.manageengine.apminsight.agent";
    private AgentConfigListener configListener;
    public static short maxTrackerInSeq;
    private int maxWebMetricStoreSize = 250;
    private int maxBackgroundMetricStoreSize = 100;
    private int maxDBMetricStoreSize = 500;
    private int maxCustomMetricStoreSize = 100;
    private int seqTraceStoreSize;
    private String agentCollectorConnectionURL;
    private boolean isCaptureJmxMetricsEnabled = true;
    private int jvmPollingInterval = 5;
    public int threadDumpMaxDepth;
    private String charsetEncoding;
    private boolean isDebugModeEnabled = false;
    private boolean isThreadProfilingEnabled = true;
    private int threadProfilingDuration = 300;
    private int threadSamplingInterval = 60;
    private int threadProfilingInterval = 28800;
    private int topNMethodsToInstrumentCount = 50;
    private int profilingStacktraceDepth = 200;
    private boolean isDiagnosticLoggingEnabled = true;
    private boolean isVulnerableJarVersionCheckEnabled = true;
    private LRUMap<String, Integer> dropThresholdPerTxn;
    private boolean autoDetectDropThresholdEnabled;
    private boolean isSmartPackageFilterEnabled = true;
    private boolean isSmartSamplingEnabled;
    private int smartSamplerCPUThreshold;
    private int smartSamplerMemoryThreshold;
    public static boolean captureHostDetails;
    private int componentsPerTxnLimit = 15;
    private String distributedTracingId;
    private boolean enableHostLicense = false;
    private boolean useActualHostname = false;
    private String tempChecksumURL;
    private String tempDownloadURL;
    private boolean isAppManagerAgent;
    private ProxyConfig proxyConfig;

    public JavaAgentConfig(JavaAgent javaAgent) throws FatalException {
        this.init();
        try {
            this.configListener = new AgentConfigListener(this, this.logger);
        }
        catch (Throwable th) {
            this.logger.warn("Unable to initialize AgentConfigListener. Exception: " + th.getMessage());
        }
    }

    public void init() throws RuntimeException, FatalException {
        String mode;
        File confFile;
        StringBuilder sb = new StringBuilder("INFO: APM Insight javaagent v");
        sb.append(JavaAgentConfig.getAgentFullVersion());
        sb.append(" successfully hooked up with JVM (PID:");
        sb.append(JavaAgentUtil.getJvmProcessId());
        sb.append(')');
        this.agentInstallDir = JavaAgentUtil.getAgentInstallDirectory();
        if (this.agentInstallDir == null) {
            String errMsg = "APM Insight: SEVERE: Unable to find agent installed directory. Try setting path in apminsight.home";
            JavaAgentUtil.print(errMsg);
            throw new FatalException(errMsg);
        }
        String homePath = this.agentInstallDir.getAbsolutePath();
        Properties agentConfigProp = null;
        try {
            confFile = new File(homePath + File.separator + "apminsight.conf");
            FileUtil.changePermissions(confFile);
            agentConfigProp = Utils.getContentAsProps(confFile);
            Utils.getContentAsProps(new File(this.agentInstallDir, "background_transaction.conf"), agentConfigProp);
            this.additionalAgentConfig.putAll(agentConfigProp);
        }
        catch (SecurityException se) {
            throw new FatalException("Agent doesnt have necessary permissions to read/write apminsight.conf file");
        }
        catch (IOException e) {
            String errMsg = "Exception occured while loading configuration files from " + homePath + e.getMessage();
            throw new FatalException(errMsg);
        }
        this.initLogging(agentConfigProp);
        JavaAgentUtil.print(sb.toString() + ". For more information check agent logs located at " + agentConfigProp.getProperty("apminsight.log.dir", this.agentInstallDir.getAbsolutePath()));
        this.logger.info(sb.toString());
        this.logger.info("JVM started using command: " + System.getProperty("sun.java.command"));
        this.logger.log(Level.DEBUG, "APM Insight config: {}", (Object)agentConfigProp);
        this.initAgentRuntimeConfig(agentConfigProp);
        this.initAgentOneTimeConfValues(agentConfigProp);
        SequenceNameChanger.initialize(new File(homePath + File.separator + "transaction_merge_patterns.conf"));
        confFile = new File(this.agentInstallDir, "transaction_drop_patterns.conf");
        if (confFile.exists()) {
            try {
                String dropPatterns = FileUtil.getInstance().readCharacterFile(confFile).replaceAll("\n", ",");
                SequenceFilterByName.initialize(dropPatterns);
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Error while reading drop patterns configurations. Exception: " + e.getMessage());
            }
        }
        if ((mode = AgentDebugModeConfig.getInstance().getConfig().getProperty("agent.debug.mode")) != null) {
            this.isDebugModeEnabled = Boolean.parseBoolean(mode);
        }
        this.contextManager = ContextInfoManager.getInstance();
        this.isContextMonitoringEnabled = Boolean.parseBoolean(agentConfigProp.getProperty("context.monitoring.enabled"));
        this.logger.info("Context based monitoring enabled: " + this.isContextMonitoringEnabled);
        if (this.isContextMonitoringEnabled) {
            ContextNameChanger.initialize(new File(this.agentInstallDir, "context_naming_patterns.conf"));
        }
        this.contextManager.createContextInfoIfNotExists("", null, null, agentConfigProp);
        this.initAgentInfoValues(agentConfigProp);
        this.initAgentConfValues(agentConfigProp);
        ThreadMxBeanUtil.initialize();
    }

    private void initLogging(Properties agentConfigProp) throws FatalException {
        Level level;
        String logDir = System.getProperty("apminsight.log.dir", agentConfigProp.getProperty("apminsight.log.dir", this.agentInstallDir.getAbsolutePath()));
        String LOG_FILE_NAME_DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss_Z";
        StringBuilder logFileName = new StringBuilder("apminsight_agent_");
        logFileName.append(new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss_Z").format(new Date(System.currentTimeMillis())));
        logFileName.append('_');
        logFileName.append(JavaAgentUtil.getJvmProcessId());
        logFileName.append(".log");
        LoggingConfig.AGENT_LOGGER.setLogDir(logDir).setLogFileName(logFileName.toString()).setLogFileNamePattern("apminsight_agent_.*log.*");
        LoggingConfig.DIAGNOSTIC_LOGGER.setLogDir(logDir).setLogFileName("apminsight_agent_diagnostics_" + JavaAgentUtil.getJvmProcessId() + ".log").setLogFileNamePattern("apminsight_agent_diagnostics_.*log.*");
        boolean isConsoleLoggingEnabled = agentConfigProp.getProperty("apminsight.console.logger") != null ? Boolean.parseBoolean(agentConfigProp.getProperty("apminsight.console.logger")) : false;
        this.loggingConfig = isConsoleLoggingEnabled ? LoggingConfig.CONSOLE_LOGGER : LoggingConfig.AGENT_LOGGER;
        String configuredLogLevel = agentConfigProp.getProperty("apminsight.log.level");
        if (!StringUtils.isEmptyString(configuredLogLevel) && (level = Level.getLevel(configuredLogLevel)) != null) {
            this.loggingConfig.setLevel(level);
        }
        AgentLoggingInitializer.getInstance().initialize(this.loggingConfig);
        JavaAgent.logger = this.logger = this.loggingConfig.getLogger();
        this.logger.info("Logging initialized successfully.");
    }

    private void initAgentInfoValues(Map agentConfigProp) throws FatalException {
        boolean isAllDeleted = false;
        try {
            File contextHome;
            String id;
            Properties agentInfoProp = Utils.getContentAsProps(new File(this.agentInstallDir, "apminsight.info"));
            if (!agentInfoProp.isEmpty() && !StringUtils.isEmptyString(id = agentInfoProp.getProperty("agent.id"))) {
                ContextInfo defaultContext = this.contextManager.getDefaultContextInfo();
                defaultContext.setInstanceID(id, false);
                try {
                    defaultContext.setAgentState(AgentState.getValueOf(agentInfoProp.getProperty("agent.state")));
                }
                catch (IllegalArgumentException e) {
                    defaultContext.setAgentState(AGENT_STATE_DV);
                }
                if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.deleted.time"))) {
                    try {
                        defaultContext.agentMarkedForDeleteTime = Long.parseLong(agentInfoProp.getProperty("agent.deleted.time"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.shutdown.time"))) {
                    JavaAgent.logger.info("Agent last shutdown time: " + agentInfoProp.getProperty("agent.shutdown.time"));
                }
                JavaAgent.logger.info("Initializing the default context " + defaultContext.toString());
                isAllDeleted = defaultContext.isDeleted();
            }
            if ((contextHome = new File(this.agentInstallDir + File.separator + "apminsight_monitors")).exists()) {
                File[] contexts;
                this.isContextMonitoringEnabled = true;
                for (File context : contexts = contextHome.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    String id2;
                    agentInfoProp = Utils.getContentAsProps(new File(context, "apminsight.info"));
                    if (agentInfoProp.isEmpty() || StringUtils.isEmptyString(id2 = agentInfoProp.getProperty("agent.id"))) continue;
                    ContextInfo contextInfo = this.contextManager.createContextInfoIfNotExists("/" + context.getName(), id2.trim(), agentInfoProp.getProperty("agent.state"), agentConfigProp);
                    if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.deleted.time"))) {
                        try {
                            contextInfo.agentMarkedForDeleteTime = Long.parseLong(agentInfoProp.getProperty("agent.deleted.time"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    JavaAgent.logger.info("Initializing the context" + contextInfo.toString());
                    isAllDeleted &= contextInfo.isDeleted();
                }
            }
            if (isAllDeleted) {
                String msg = "Agent is in deleted state. Agent Initialization Aborted!";
                this.logger.log(Level.FATAL, msg);
                throw new FatalException(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initAgentRuntimeConfig(Properties agentConfigProp) {
        if (!this.agentVerified) {
            this.licenseKey = agentConfigProp.getProperty("license.key");
            String string = this.licenseKey = StringUtils.isEmptyString(this.licenseKey) ? System.getProperty("apminsight.license.key", System.getenv("S247_LICENSE_KEY")) : this.licenseKey;
            if (StringUtils.isEmptyString(this.licenseKey)) {
                this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"license.key");
                throw new RuntimeException("license.key is invalid.");
            }
            this.licenseKey = StringUtils.efficientTrim(this.licenseKey);
            try {
                this.licenseKey = SecurityUtil.decryptString(this.licenseKey, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.licenseKey.startsWith("APMI_")) {
                this.isAppManagerAgent = true;
                if (!this.licenseKey.matches("^APMI_[A-Fa-f0-9]{64}$")) {
                    this.logger.log(Level.FATAL, "Invalid license key provided. Kindly provide correct one");
                    throw new RuntimeException("license.key property is invalid.");
                }
            }
            this.distributedTracingId = this.generateDTId();
            dataCenter = JavaAgentUtil.getDataCenter(this.licenseKey);
            this.applicationName = System.getProperty("apminsight.application.name", agentConfigProp.getProperty("application.name"));
            if (StringUtils.isEmptyString(this.applicationName)) {
                JavaAgentUtil.print("SEVERE: [APM Insight] Valid value for key \"application.name\" must be set.");
                this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"application.name");
            } else {
                this.logger.info("Application Name: " + this.applicationName);
            }
            try {
                this.agentServerPort = Integer.parseInt(System.getProperty("apminsight.agent.server.port", agentConfigProp.getProperty("agent.server.port")));
                this.logger.info("Server port: " + this.agentServerPort);
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"agent.server.port");
                throw new RuntimeException("Valid agent.server.port must be set.");
            }
            this.useActualHostname = Boolean.parseBoolean(agentConfigProp.getProperty("use.actual.hostname"));
            this.enableHostLicense = Boolean.parseBoolean(agentConfigProp.getProperty("hostlicense.apply"));
        }
        this.initConnectionConfig(agentConfigProp);
        try {
            JavaAgentUtil.encryptSensitiveData(new File(this.agentInstallDir, "apminsight.conf"));
        }
        catch (Exception ex) {
            this.logger.log(Level.WARN, "Exception: " + ex.getMessage(), ex);
        }
    }

    void initConnectionConfig(Properties agentConfigProp) {
        block10: {
            this.apmHost = System.getProperty("apminsight.apm.host", agentConfigProp.getProperty("apm.host"));
            if (!StringUtils.isEmptyString(this.apmHost)) {
                this.apmHost = StringUtils.efficientTrim(this.apmHost);
            }
            if (this.isAppManagerAgent && StringUtils.isEmptyString(this.apmHost)) {
                this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"apm.host");
                throw new RuntimeException("apm.host property must be set.");
            }
            boolean bl = this.isBehindProxy = System.getProperty("apminsight.agent.proxy") != null ? true : Boolean.parseBoolean(agentConfigProp.getProperty("behind.proxy"));
            if (this.isBehindProxy) {
                try {
                    String proxyStr = System.getProperty("apminsight.agent.proxy");
                    if (!StringUtils.isEmptyString(proxyStr)) {
                        String[] info = proxyStr.split("@");
                        if (info.length > 1) {
                            String[] user = info[0].split(":");
                            String[] host = info[1].split(":");
                            this.proxyConfig = new ProxyConfig(host[0], host[1], user[0], user[1]);
                        } else {
                            String[] host = info[1].split(":");
                            this.proxyConfig = new ProxyConfig(host[0], host[1], "", "");
                        }
                        break block10;
                    }
                    String pswd = agentConfigProp.getProperty("proxy.auth.password", "");
                    try {
                        String plainText = SecurityUtil.decryptString(pswd, this.licenseKey);
                        pswd = plainText != null ? plainText : pswd;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.proxyConfig = new ProxyConfig(agentConfigProp.getProperty("proxy.server.host"), agentConfigProp.getProperty("proxy.server.port"), agentConfigProp.getProperty("proxy.auth.username", ""), pswd);
                }
                catch (Exception e) {
                    this.logger.warn("Ignoring Proxy details. " + e.getMessage());
                    this.isBehindProxy = false;
                }
            }
        }
        this.constructAgentCollectorConnectionURL();
    }

    void initAgentConfValues(Map<String, Object> agentConfig) throws RuntimeException {
        AsyncTracerService.getInstance().init(agentConfig);
        Object tempVar = null;
        tempVar = agentConfig.get("diagnostic.logging.enabled");
        if (tempVar != null) {
            this.isDiagnosticLoggingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("checksum.fetch.url")) != null) {
            this.tempChecksumURL = tempVar.toString().trim();
        }
        if ((tempVar = agentConfig.get("agent.download.url")) != null) {
            this.tempDownloadURL = tempVar.toString().trim();
        }
        if ((tempVar = agentConfig.get("agent.polling.interval")) != null) {
            try {
                this.agentPollingInterval = Integer.parseInt(tempVar.toString());
                this.agentPollingInterval = this.agentPollingInterval < 60 ? 60 : this.agentPollingInterval;
                this.logger.log(Level.INFO, "Agent Polling Interval set to " + this.agentPollingInterval / 60 + " minute(s)");
            }
            catch (Exception e) {
                this.agentPollingInterval = 60;
            }
        }
        this.isSmartSamplingEnabled = (tempVar = agentConfig.get("smart.sampler.enabled")) != null ? Boolean.parseBoolean(tempVar.toString()) : SMART_SAMPLER_ENABLED_DV;
        try {
            this.smartSamplerCPUThreshold = Integer.parseInt(agentConfig.get("smart.sampler.cpuThreshold").toString());
        }
        catch (Exception e) {
            this.smartSamplerCPUThreshold = 70;
        }
        try {
            this.smartSamplerMemoryThreshold = Integer.parseInt(agentConfig.get("smart.sampler.usedMemoryThreshold").toString());
        }
        catch (Exception e) {
            this.smartSamplerMemoryThreshold = 70;
        }
        try {
            tempVar = agentConfig.get("sequence.bag.max.tracker");
            maxTrackerInSeq = Short.parseShort(tempVar.toString());
        }
        catch (Exception ne) {
            maxTrackerInSeq = (short)1000;
        }
        try {
            tempVar = agentConfig.get("agent.print.statistics");
            this.printStatistics = Byte.parseByte(tempVar.toString());
        }
        catch (Exception ne) {
            this.printStatistics = 0;
        }
        try {
            tempVar = agentConfig.get("transient.rootracker.vault.size");
            this.trackerStoreSize = Integer.parseInt(tempVar.toString());
        }
        catch (Exception e) {
            this.trackerStoreSize = 500;
        }
        tempVar = agentConfig.get("metricstore.metric.bucket.size");
        if (tempVar != null) {
            try {
                this.maxWebMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.metric.bucket.size", this.maxWebMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.bgmetric.bucket.size")) != null) {
            try {
                this.maxBackgroundMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.bgmetric.bucket.size", this.maxBackgroundMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.dbmetric.bucket.size")) != null) {
            try {
                this.maxDBMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.maxDBMetricStoreSize = 500;
            }
        }
        if ((tempVar = agentConfig.get("metricstore.custom.metric.bucket.size")) != null) {
            try {
                this.maxCustomMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.maxCustomMetricStoreSize = 100;
            }
        }
        try {
            tempVar = agentConfig.get("transaction.tracestore.size");
            this.seqTraceStoreSize = Integer.parseInt(tempVar.toString());
        }
        catch (Exception e) {
            this.seqTraceStoreSize = 30;
        }
        tempVar = agentConfig.get("sql.capture.use_reflection");
        this.captureSqlByReflection = tempVar == null ? SQL_CAPTURE_USE_REFLECTION_DV : Boolean.parseBoolean(tempVar.toString());
        tempVar = agentConfig.get("capture.jmx.metrics");
        if (tempVar != null) {
            this.isCaptureJmxMetricsEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("jvm.polling.interval")) != null) {
            try {
                this.jvmPollingInterval = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.jvmPollingInterval = 5;
            }
        }
        try {
            this.threadDumpMaxDepth = Integer.parseInt(agentConfig.get("thread.dump.maxdepth").toString());
            if (this.threadDumpMaxDepth < 1) {
                this.threadDumpMaxDepth = Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            this.threadDumpMaxDepth = 20;
        }
        try {
            tempVar = agentConfig.get("webtransaction.encoding.charset");
            this.charsetEncoding = tempVar != null && Charset.isSupported(tempVar.toString()) ? tempVar.toString() : "UTF-8";
        }
        catch (Throwable th) {
            this.charsetEncoding = "UTF-8";
        }
        tempVar = agentConfig.get("apminsight.log.level");
        if (tempVar != null) {
            this.logger.setLevel(tempVar.toString().toUpperCase());
        }
        this.autoDetectDropThresholdEnabled = (tempVar = agentConfig.get("transaction.tracker.drop.threshold.autodetect")) == null ? true : Boolean.parseBoolean(tempVar.toString());
        this.dropThresholdPerTxn = this.autoDetectDropThresholdEnabled ? new LRUMap(25) : null;
        tempVar = agentConfig.get("thread.profiling.enabled");
        if (tempVar != null) {
            this.isThreadProfilingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("thread.profiling.duration")) != null) {
            try {
                this.threadProfilingDuration = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.threadProfilingDuration = 300;
            }
        }
        if ((tempVar = agentConfig.get("thread.sampling.interval")) != null) {
            try {
                this.threadSamplingInterval = Integer.parseInt(tempVar.toString());
                if (this.threadSamplingInterval < 60) {
                    this.threadSamplingInterval = 60;
                    this.logger.log(Level.WARN, "Thread Sampling interval is too low, this may affect your application performance. Setting it to 60");
                }
            }
            catch (Throwable th) {
                this.threadSamplingInterval = 60;
            }
        }
        if ((tempVar = agentConfig.get("thread.profiling.interval")) != null) {
            try {
                this.threadProfilingInterval = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.threadProfilingInterval = 28800;
            }
        }
        if ((tempVar = agentConfig.get("profiling.top.method.count")) != null) {
            try {
                this.topNMethodsToInstrumentCount = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.topNMethodsToInstrumentCount = 50;
            }
        }
        if ((tempVar = agentConfig.get("profiling.stacktrace.depth")) != null) {
            try {
                this.profilingStacktraceDepth = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.profilingStacktraceDepth = 200;
            }
        }
        if ((tempVar = agentConfig.get("smart.package.filter.enabled")) != null) {
            this.isSmartPackageFilterEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("capture.externalcalls.hostdetails")) != null) {
            captureHostDetails = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.component.store.size")) != null) {
            try {
                this.componentsPerTxnLimit = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.componentsPerTxnLimit = 15;
            }
        }
        if ((tempVar = agentConfig.get("vulnerable.jar.check.enabled")) != null) {
            this.isVulnerableJarVersionCheckEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if (!StringUtils.isEmptyString((String)(tempVar = agentConfig.get("application.group.name")))) {
            this.additionalAgentConfig.put("application.group.name", (String)tempVar);
        }
        tempVar = agentConfig.get("tags");
        try {
            if (!StringUtils.isEmptyString((String)tempVar)) {
                String[] tags = tempVar.toString().split(",");
                HashMap<String, String> tagValues = new HashMap<String, String>();
                for (String tag : tags) {
                    String[] keyValue = tag.split(":", 2);
                    tagValues.put(keyValue[0], keyValue[1]);
                }
                this.additionalAgentConfig.put("tags", tagValues);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while processing tags value. Exception: " + e.getMessage());
            this.additionalAgentConfig.remove("tags");
        }
    }

    void initAgentOneTimeConfValues(Map agentConfigProp) {
        block12: {
            try {
                File customInstrumentationConf = new File(this.agentInstallDir, "custom_instrumentation.conf");
                Properties props = Utils.getContentAsProps(customInstrumentationConf);
                if (props.isEmpty()) break block12;
                HashMap customInstrumentation = new HashMap();
                for (Map.Entry entry : props.entrySet()) {
                    String component;
                    if (((String)entry.getKey()).matches("com/manageengine/apminsight/agent.*|com/amazonaws.*")) continue;
                    HashMap<String, String> methodsMap = new HashMap<String, String>();
                    String[] methodComponent = ((String)entry.getValue()).replaceAll("\\s+", "").split(":");
                    String string = component = methodComponent.length > 1 ? methodComponent[1] : "DEFAULT";
                    if (methodComponent.length > 0) {
                        for (String method : methodComponent[0].split(",")) {
                            if (method.equals("")) {
                                method = "*";
                                methodsMap.clear();
                                methodsMap.put(method, component);
                                break;
                            }
                            methodsMap.put(method, component);
                        }
                    } else {
                        methodsMap.put("*", "DEFAULT");
                    }
                    customInstrumentation.put(entry.getKey(), methodsMap);
                }
                if (!customInstrumentation.isEmpty()) {
                    this.additionalAgentConfig.put("custom.instrumentation", customInstrumentation);
                    this.logger.info("Custom Instrumentation configurations read and ready to sent to server. " + customInstrumentation);
                } else {
                    this.logger.info("No custom instrumentation configured removing the stock conf file.");
                    customInstrumentationConf.delete();
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Error in initializing custom package instrumentation", th);
            }
        }
        try {
            String excludePackages = (String)agentConfigProp.get("exclude.packages");
            if (!StringUtils.isEmptyString(excludePackages)) {
                InstrumentationFilter.updateExclusionPattern(excludePackages);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Exception in updating exclude patterns.", e);
        }
    }

    private String generateDTId() {
        if (this.distributedTracingId == null) {
            if (this.licenseKey == null || this.licenseKey.length() < 12) {
                this.distributedTracingId = null;
            }
            this.distributedTracingId = this.licenseKey.substring(this.licenseKey.length() - 12);
        }
        return this.distributedTracingId;
    }

    public Map<String, Object> getVMEnvironment() {
        LinkedHashMap<String, Object> vmEnv = new LinkedHashMap<String, Object>();
        vmEnv.put("Agent Install Path", this.agentInstallDir.getAbsolutePath());
        vmEnv.put("Agent Version", AGENT_MAJOR_VERSION);
        if (this.lastKnownAgentShutdownTime != 0L) {
            vmEnv.put("agent.shutdown.time", this.lastKnownAgentShutdownTime);
        }
        if (this.isVulnerableJarVersionCheckEnabled) {
            VulnerableJarVersionCollector vulnerableJarVersionCollector = VulnerableJarVersionCollector.getInstance();
            vulnerableJarVersionCollector.collectUndetectedJarVersions();
            for (Map.Entry<String, String> entry : vulnerableJarVersionCollector.getAllDetectedJarVersions()) {
                vmEnv.put(entry.getKey() + " Version", entry.getValue());
            }
        }
        try {
            vmEnv.put("OS", System.getProperty("os.name"));
            vmEnv.put("OS Version", System.getProperty("os.version"));
            vmEnv.put("OS Arch", System.getProperty("os.arch"));
            vmEnv.put("Application Server", EnvironmentIdentifier.getAppServer().toString());
            vmEnv.put("JVM Name", System.getProperty("java.vm.name"));
            vmEnv.put("JVM Version", System.getProperty("java.vm.version"));
            vmEnv.put("Java Vendor", System.getProperty("java.vendor"));
            vmEnv.put("Java Version", System.getProperty("java.version"));
            this.logger.info("Java Version: " + System.getProperty("java.version"));
            vmEnv.put("Java Home", System.getProperty("java.home"));
            vmEnv.put("Class Version", System.getProperty("java.class.version"));
            vmEnv.put("IP", HostNameUtil.getIPAddresses());
            this.logger.info("Classpath: " + System.getProperty("java.class.path"));
            this.logger.info("Library Path: " + System.getProperty("java.library.path"));
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavAgentConfig - Failed to collect jvm information. " + th);
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            double classVersion = Double.parseDouble(System.getProperty("java.class.version"));
            if (classVersion < 53.0) {
                this.logger.info("Boot Classpath: " + runtimeMXBean.getBootClassPath());
            }
            this.logger.info("Java Arguments: " + runtimeMXBean.getInputArguments());
            vmEnv.put("Application Starttime", runtimeMXBean.getStartTime());
            vmEnv.put("Jvm PID", runtimeMXBean.getName().split("@")[0]);
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavaAgentConfig - Failed to get runtime information.", th);
        }
        try {
            MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            vmEnv.put("Heap Initial", JavaAgentUtil.convertBytesToMB(heapMemoryUsage.getInit()));
            vmEnv.put("Heap Maximum", JavaAgentUtil.convertBytesToMB(heapMemoryUsage.getMax()));
            MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
            vmEnv.put("Non-Heap Initial", JavaAgentUtil.convertBytesToMB(nonHeapMemoryUsage.getInit()));
            vmEnv.put("Non-Heap Maximum", JavaAgentUtil.convertBytesToMB(nonHeapMemoryUsage.getMax()));
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavaAgentConfig - Failed to get heap/nonheap memory information.", th);
        }
        if (((Object)vmEnv).toString().length() > 25000) {
            vmEnv.remove("Classpath");
            vmEnv.remove("Java Arguments");
        }
        return vmEnv;
    }

    public Map<String, Object> getAgentCollectorSyncConfValues() {
        if (this.additionalAgentConfig.containsKey("license.key")) {
            this.additionalAgentConfig.remove("license.key");
            this.additionalAgentConfig.remove("application.name");
            this.additionalAgentConfig.remove("behind.proxy");
            this.additionalAgentConfig.remove("proxy.server.host");
            this.additionalAgentConfig.remove("proxy.server.port");
            this.additionalAgentConfig.remove("proxy.auth.username");
            this.additionalAgentConfig.remove("proxy.auth.password");
            this.additionalAgentConfig.remove("apm.host");
            this.additionalAgentConfig.remove("apm.port");
            this.additionalAgentConfig.remove("apm.protocol.https");
            this.additionalAgentConfig.remove("agent.server.port");
            this.additionalAgentConfig.remove("apminsight.log.dir");
            this.additionalAgentConfig.remove("apminsight.log.level");
            this.additionalAgentConfig.remove("apminsight.console.logger");
            this.additionalAgentConfig.remove("hostlicense.apply");
            this.additionalAgentConfig.remove("use.actual.hostname");
            this.additionalAgentConfig.remove("context.monitoring.enabled");
        }
        if (this.additionalAgentConfig.isEmpty()) {
            return null;
        }
        this.additionalAgentConfig.put("last.modified.time", this.configListener.getLastModifiedTime());
        return this.additionalAgentConfig;
    }

    public void writeAgentInfo(ContextInfo info) {
        if (StringUtils.isEmptyString(info.getInstanceID())) {
            return;
        }
        Properties p = new Properties();
        p.setProperty("agent.id", "" + info.getInstanceID());
        p.setProperty("agent.state", info.getInstanceState().toString());
        p.setProperty("agent.version", JavaAgentConfig.getAgentFullVersion());
        if (info.getInstanceState() == AgentState.MARKED_FOR_DELETE) {
            p.setProperty("agent.deleted.time", String.valueOf(info.agentMarkedForDeleteTime));
        }
        String contextName = info.getContextName();
        String filePath = this.agentInstallDir + File.separator;
        if (!contextName.isEmpty()) {
            filePath = filePath + "apminsight_monitors" + File.separator + contextName.substring(1) + File.separator;
        }
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            filePath = filePath + "apminsight.info";
            Utils.writePropsAsFile(p, filePath);
            this.logger.info("Agent info successfully updated at " + filePath);
            FileUtil.changePermissions(filePath);
        }
        catch (SecurityException se) {
            this.logger.warn("Unable to set user permissions for info file: " + filePath);
        }
        catch (Throwable ex) {
            this.logger.warn("Unable to write the agent info at " + filePath + ". Exception: " + ex.getMessage() + "APM Insight will continue to work keeping agent info in memory");
        }
    }

    public void refreshNow() {
        if (this.configListener != null) {
            try {
                this.configListener.execute();
            }
            catch (Throwable th) {
                this.logger.warn("Unable to execute configListener. Exception: " + th.getMessage());
            }
        }
    }

    public void reinit() {
        if (this.isDebugModeEnabled) {
            HashMap<String, Object> customConfig = new HashMap<String, Object>(this.agentUserConfig);
            customConfig.putAll(AgentDebugModeConfig.getInstance().getConfig());
            this.initAgentConfValues(customConfig);
        } else {
            this.initAgentConfValues(this.agentUserConfig);
        }
    }

    public int getAgentPollingInterval() {
        return this.agentPollingInterval;
    }

    public boolean isProxyEnabled() {
        return this.isBehindProxy;
    }

    public String getTempChecksumURL() {
        return this.tempChecksumURL;
    }

    public String getTempAgentDownloadURL() {
        return this.tempDownloadURL;
    }

    public AgentLogger getLogger() {
        return this.logger;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getAPMHost() {
        return this.apmHost;
    }

    public DataCenter getDataCenter() {
        return dataCenter;
    }

    public boolean isDesktopApp() {
        return System.getProperty("APMDesktop") != null;
    }

    public File getAgentInstallDir() {
        return this.agentInstallDir;
    }

    public String getApminsightPkg() {
        return APMINSIGHT_PKG;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getAgentServerPort() {
        return this.agentServerPort;
    }

    public byte printAgentStatistics() {
        return this.printStatistics;
    }

    public int getTrackerStoreSize() {
        return this.trackerStoreSize;
    }

    public int getMaxWebMetricStoreSize() {
        return this.maxWebMetricStoreSize;
    }

    public int getMaxBackgroundMetricStoreSize() {
        return this.maxBackgroundMetricStoreSize;
    }

    public int getMaxDBMetricStoreSize() {
        return this.maxDBMetricStoreSize;
    }

    public int getMaxCustomMetricStoreSize() {
        return this.maxCustomMetricStoreSize;
    }

    public int getSeqTraceStoreSize() {
        return this.seqTraceStoreSize;
    }

    public String getAgentCollectorConnectionURL() {
        return this.agentCollectorConnectionURL;
    }

    public int getJvmPollingInterval() {
        return this.jvmPollingInterval * 60;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public Integer getDropThreshold(String seqNameSpace) {
        try {
            if (this.dropThresholdPerTxn != null) {
                return (Integer)this.dropThresholdPerTxn.get(seqNameSpace);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Error occurred in get operation in LRUMap. Exception: ", e);
        }
        return null;
    }

    public Integer setDropThreshold(String seqNameSpace, Integer dropThreshold) {
        try {
            if (dropThreshold != null) {
                return this.dropThresholdPerTxn.put(seqNameSpace, dropThreshold);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Error occurred in put operation in LRUMap. Exception: ", e);
        }
        return null;
    }

    public void clearDropThreshold() {
        if (this.dropThresholdPerTxn != null) {
            this.dropThresholdPerTxn.clear();
            this.logger.debug("Auto drop tracker threshold per transaction data is cleared");
        }
    }

    public boolean isAutoDetectDropThresholdEnabled() {
        return this.autoDetectDropThresholdEnabled;
    }

    public static String getAgentFullVersion() {
        return "6.0.1";
    }

    public boolean isCaptureJmxMetricsEnabled() {
        return this.isCaptureJmxMetricsEnabled;
    }

    public boolean isContextMonitoringEnabled() {
        return this.isContextMonitoringEnabled;
    }

    public int getSmartSamplerCPUThreshold() {
        return this.smartSamplerCPUThreshold;
    }

    public int getSmartSamplerMemoryThreshold() {
        return this.smartSamplerMemoryThreshold;
    }

    public boolean isSmartSamplingEnabled() {
        return this.isSmartSamplingEnabled;
    }

    public boolean isSmartPackageFilterEnabled() {
        return this.isSmartPackageFilterEnabled;
    }

    public int getComponentsPerTxnLimit() {
        return this.componentsPerTxnLimit;
    }

    public void updateAdditionalAgentConfig(Map config) {
        this.additionalAgentConfig.clear();
        this.additionalAgentConfig.putAll(config);
    }

    public void updateAgentUserConfig(Map config) {
        this.agentUserConfig.putAll(config);
    }

    public Map<String, Object> getAgentUserConfig() {
        return this.agentUserConfig;
    }

    public boolean isDebugModeEnabled() {
        return this.isDebugModeEnabled;
    }

    public void enableDebugMode() {
        this.isDebugModeEnabled = true;
        try {
            this.reinit();
            this.scheduleDebugModeDisableTask();
            this.logger.info("DEBUG mode has been enabled.");
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "Error Occurred while enabling debug mode. Exception: ", th);
        }
    }

    public void scheduleDebugModeDisableTask() {
        int debugModeDuration = AgentDebugModeConfig.getInstance().getDebugModeDuration();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(WorkerThreadFactory.getInstance());
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("apminsight-debug-mode");
                JavaAgentConfig.this.isDebugModeEnabled = false;
                try {
                    JavaAgentConfig.this.reinit();
                    File debugFile = new File(JavaAgentConfig.this.agentInstallDir, "debug_mode.conf");
                    HashMap<String, String> resetConfig = new HashMap<String, String>();
                    resetConfig.put("agent.debug.mode", "false");
                    FileUtil.refillPropertiesFile(debugFile, resetConfig, false);
                    JavaAgentConfig.this.configListener.updateLastModifiedTime();
                    JavaAgentConfig.this.logger.info("Debug mode disabled. Agent configurations resetted to user-defined values");
                }
                catch (Throwable th) {
                    JavaAgentConfig.this.logger.log(Level.WARN, "Error Occurred while disabling debug mode. Exception: ", th);
                }
            }
        }, (long)debugModeDuration, TimeUnit.SECONDS);
        this.logger.info("DEBUG mode disable task scheduled to execute in " + debugModeDuration + " seconds.");
    }

    public boolean isVulnerableJarVersionCheckEnabled() {
        return this.isVulnerableJarVersionCheckEnabled;
    }

    public boolean isThreadProfilingEnabled() {
        return this.isThreadProfilingEnabled;
    }

    public boolean isDiagnosticLoggingEnabled() {
        return this.isDiagnosticLoggingEnabled;
    }

    public int getThreadProfilingDuration() {
        return this.threadProfilingDuration;
    }

    public int getThreadSamplingInterval() {
        return this.threadSamplingInterval;
    }

    public int getThreadProfilingInterval() {
        return this.threadProfilingInterval;
    }

    public int getTopNMethodsToInstrumentCount() {
        return this.topNMethodsToInstrumentCount;
    }

    public int getProfilingStacktraceDepth() {
        return this.profilingStacktraceDepth;
    }

    public String getDistributedTracingId() {
        return this.distributedTracingId;
    }

    public boolean isUseActualHostname() {
        return this.useActualHostname;
    }

    public boolean isEnableHostLicense() {
        return this.enableHostLicense;
    }

    public boolean isAppManagerAgent() {
        return this.isAppManagerAgent;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    private void constructAgentCollectorConnectionURL() {
        StringBuilder sb = new StringBuilder();
        this.agentCollectorConnectionURL = StringUtils.isEmptyString(this.getAPMHost()) ? dataCenter.getCollectorDomain() : this.getAPMHost();
        this.agentCollectorConnectionURL = this.agentCollectorConnectionURL + "/arh/";
    }

    public void removeNonNativeConfigs() {
        try {
            String line;
            File confFile = new File(this.agentInstallDir, "background_transaction.conf");
            if (confFile.exists()) {
                confFile.delete();
                JavaAgent.logger.info("background_transaction.conf file has been deleted successfully.");
            }
            if ((confFile = new File(this.agentInstallDir, "custom_instrumentation.conf")).exists()) {
                boolean isSuccess = confFile.renameTo(new File(this.agentInstallDir, "instrumentation.conf"));
                JavaAgent.logger.info("custom_instrumentation.conf file has been renamed: " + isSuccess);
            }
            confFile = new File(this.agentInstallDir, "apminsight.conf");
            Properties agentConfigProps = Utils.getContentAsProps(confFile);
            agentConfigProps.remove("application.group.name");
            agentConfigProps.remove("tags");
            BufferedReader br = new BufferedReader(new FileReader(confFile));
            StringBuffer fileContent = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) {
                    fileContent.append(line);
                } else {
                    String[] keyValue = (line = line + " ").split("=");
                    if (keyValue.length == 1) {
                        keyValue = line.split(":");
                    }
                    if (keyValue.length != 1 && agentConfigProps.getProperty(keyValue[0].trim()) == null) continue;
                    fileContent.append(line.trim());
                }
                fileContent.append('\n');
            }
            br.close();
            if (fileContent.length() == 0) {
                JavaAgent.logger.warn("Error while updating conf file, content is empty. Aborting write operation to conf file");
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(confFile));
            out.write(fileContent.toString());
            out.close();
            JavaAgent.logger.info("All additional config properties are removed from apminsight.conf file");
            this.configListener.updateLastModifiedTime();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while removing non-native configurations. Exception: " + th.getMessage());
        }
    }

    static {
        captureHostDetails = true;
    }
}

