/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.MemoryLeakUserActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.ondemand.OnDemandTask;

public class MemoryLeakCapturingTask
extends OnDemandTask {
    public int samplingInterval;
    public int captureDuration;
    public static boolean isOnDemandTaskAlreadyScheduled = false;

    public MemoryLeakCapturingTask(int captureDuration, int samplingInterval) {
        super("memory-leak-detection", OnDemandTask.TaskWeightage.HEAVY);
        this.samplingInterval = samplingInterval;
        this.captureDuration = captureDuration;
    }

    @Override
    public void runTask() {
        try {
            AutomaticLeakDetection.getInstance().activate();
            isOnDemandTaskAlreadyScheduled = true;
            AutomaticLeakDetection.OnDemandCollectionRecorder.getInstance().startOnDemandCollectionRecorder(this.captureDuration, this.samplingInterval);
            JavaAgent.logger.info("************************ MEMORY PROFILING TASK STARTED **************************");
            Thread.sleep(this.captureDuration * 60 * 1000 - 4000);
            isOnDemandTaskAlreadyScheduled = false;
            JavaAgent.logger.info("************************ MEMORY PROFILING TASK ENDED **************************");
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception while instrumenting for on demand capture", e);
        }
    }

    @Override
    public boolean abortTask() {
        MemoryLeakUserActionHandler.stopMemoryLeakProfiling();
        return true;
    }
}

