/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.MemoryLeakCapturingTask;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.memoryleaks.config.UserActionHandler;
import com.manageengine.apminsight.agent.ondemand.OnDemandTasksHandler;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryLeakUserActionHandler
implements AgentServiceConstants {
    public static void startMemoryLeakProfiling(int captureDuration, int samplingInterval) {
        if (!MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled) {
            JavaAgent.logger.info("Memory leak Task is scheduled.");
            OnDemandTasksHandler.addTask(new MemoryLeakCapturingTask(captureDuration, samplingInterval));
        } else {
            JavaAgent.logger.info("Memory leak Task is already scheduled.");
        }
    }

    public static void stopMemoryLeakProfiling() {
        if (MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled) {
            MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled = false;
        }
        AutomaticLeakDetection.getInstance().deActivate();
    }

    public static void processUserTriggeredActions(List userEvents) {
        try {
            HashMap<Integer, List<ActionHandler>> actionMap = new HashMap<Integer, List<ActionHandler>>();
            for (int i = 0; i < userEvents.size(); ++i) {
                Map events = (Map)userEvents.get(i);
                int actionId = Integer.parseInt(String.valueOf(events.get("memleak.action.type")));
                long userActionId = Long.parseLong(String.valueOf(events.get("memleak.action.id")));
                int durationInMillis = 0;
                durationInMillis = Integer.parseInt(String.valueOf(events.get("memleak.action.capture.duration")));
                List objectUUids = (List)events.get("memleak.object.id");
                ArrayList<ActionHandler> handlerList = null;
                for (int j = 0; j < objectUUids.size(); ++j) {
                    handlerList = (ArrayList<ActionHandler>)actionMap.get(actionId);
                    if (handlerList == null) {
                        handlerList = new ArrayList<ActionHandler>();
                    }
                    handlerList.add(new UserActionHandler(userActionId, (Long)objectUUids.get(j), actionId, durationInMillis).getHandler());
                    actionMap.put(actionId, handlerList);
                }
            }
            if (!actionMap.isEmpty()) {
                AutomaticLeakDetection.getInstance().delegateAction(actionMap);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception while reading user action", e);
        }
    }
}

