/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.installer.AppServer;
import java.io.File;

public final class AppServerIdentifier {
    private static final String TOMCAT_IDENTIFIER = "/lib/catalina.jar";
    private static final String JBOSS_AS_IDENTIFIER = "/lib/jboss-system.jar";
    private static final String JBOSS_EAP_IDENTIFER = "/jboss-modules.jar";
    private static final String WILDFLY_IDENTIFIER = "/bin/init.d/wildfly.conf";
    private static final String JETTY_IDENTIFIER = "/bin/jetty.sh";

    public static AppServer identify(String serverPath) {
        if (AppServerIdentifier.isTomcat(serverPath)) {
            return AppServer.TOMCAT;
        }
        if (AppServerIdentifier.isJBossAS(serverPath)) {
            return AppServer.JBOSS_AS;
        }
        if (AppServerIdentifier.isWildfly(serverPath)) {
            return AppServer.WILDFLY;
        }
        if (AppServerIdentifier.isJBossEAP(serverPath)) {
            return AppServer.JBOSS_EAP;
        }
        if (AppServerIdentifier.isJetty(serverPath)) {
            return AppServer.JETTY;
        }
        return AppServer.UNKNOWN;
    }

    private static boolean isTomcat(String serverPath) {
        return AppServerIdentifier.isExists(serverPath + TOMCAT_IDENTIFIER);
    }

    private static boolean isJBossAS(String serverPath) {
        return AppServerIdentifier.isExists(serverPath + JBOSS_AS_IDENTIFIER);
    }

    private static boolean isJBossEAP(String serverPath) {
        return AppServerIdentifier.isExists(serverPath + JBOSS_EAP_IDENTIFER);
    }

    private static boolean isWildfly(String serverPath) {
        return AppServerIdentifier.isExists(serverPath + WILDFLY_IDENTIFIER);
    }

    private static boolean isJetty(String serverPath) {
        return AppServerIdentifier.isExists(serverPath + JETTY_IDENTIFIER);
    }

    private static boolean isExists(String identifier) {
        File file = new File(identifier);
        return file.exists();
    }
}

