/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.instrumentation.BasicAnnotationVisitor;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.MethodInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.org.objectweb.asm.AnnotationVisitor;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import java.util.List;

public class AnnotationIdentifier
extends ClassVisitor {
    private List<InterceptorDefinition> annotatedMethods;
    private List<InterceptorDefinition> interceptors;
    private String className;
    private boolean isClassAnnotated = false;

    public AnnotationIdentifier(String className, List<InterceptorDefinition> annotatedMethods, List<InterceptorDefinition> annotationInterceptors) {
        super(589824);
        this.className = className;
        this.annotatedMethods = annotatedMethods;
        this.interceptors = annotationInterceptors;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String description, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, description, signature, exceptions);
        if (this.isClassAnnotated || name.matches("<(cl)?init>")) {
            return mv;
        }
        MethodVisitor methodVisitor = new MethodVisitor(589824, mv){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (visible) {
                    for (InterceptorDefinition interceptor : AnnotationIdentifier.this.interceptors) {
                        if (!((AnnotationInterceptorDefinition)interceptor).annotationMatcher.matches(desc)) continue;
                        StringBuilder attributes = new StringBuilder();
                        BasicAnnotationVisitor annotationVisitor = new BasicAnnotationVisitor(589824, av, attributes);
                        AnnotationIdentifier.this.annotatedMethods.add(new AnnotationInterceptorDefinition(interceptor.interceptorName, new ClassMatcher(AnnotationIdentifier.this.className), null, new MethodMatcher(name, description), attributes));
                        return annotationVisitor;
                    }
                }
                return av;
            }
        };
        return methodVisitor;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String description, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(description, visible);
        if (!this.isClassAnnotated) {
            for (InterceptorDefinition interceptor : this.interceptors) {
                if (!((AnnotationInterceptorDefinition)interceptor).annotationMatcher.matches(description)) continue;
                StringBuilder attributes = new StringBuilder();
                BasicAnnotationVisitor annotationVisitor = new BasicAnnotationVisitor(589824, av, attributes);
                this.annotatedMethods.add(new AnnotationInterceptorDefinition(interceptor.interceptorName, new ClassMatcher(this.className), null, MethodInterceptorDefinition.ALL_METHOD_MATCHER, attributes));
                this.isClassAnnotated = true;
                return annotationVisitor;
            }
        }
        return av;
    }

    public boolean isClassAnotated() {
        return this.isClassAnnotated;
    }
}

