/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentHandler;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.Label;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import com.manageengine.org.objectweb.asm.Type;
import com.manageengine.org.objectweb.asm.commons.AdviceAdapter;
import com.manageengine.org.objectweb.asm.commons.Method;

public class BasicMethodAdapter
extends AdviceAdapter {
    private static final String AGENT_INTERNAL_NAME = JavaAgent.class.getName().replace('.', '/');
    private static final String HANDLER_INTERNAL_NAME = JavaAgentHandler.class.getName().replace('.', '/');
    private static final String HANDLE_NAME = "getHandler";
    private static final String HANDLE_METHOD_DESC = "()L" + HANDLER_INTERNAL_NAME + ";";
    private static final String TRACE_METHOD_DESC = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/String;)Lcom/manageengine/apminsight/agent/trackers/Tracker;";
    protected String className;
    protected String methodName;
    protected String pointCutName;
    private Label startFinally = new Label();
    private int tracerVarId;
    private String annotationAttributes;

    protected BasicMethodAdapter(ClassVisitor adapter, String className, MethodVisitor mv, int access, String methodName, String description, InterceptorDefinition matchedInterceptor) {
        super(589824, mv, access, methodName, description);
        this.className = className;
        this.methodName = methodName;
        this.pointCutName = matchedInterceptor.interceptorName;
        if (matchedInterceptor instanceof AnnotationInterceptorDefinition) {
            this.annotationAttributes = ((AnnotationInterceptorDefinition)matchedInterceptor).getAnnotationAttributes();
        }
    }

    @Override
    public void visitCode() {
        super.visitCode();
        super.visitLabel(this.startFinally);
    }

    @Override
    protected void onMethodEnter() {
        this.tracerVarId = this.newLocal(Type.getType(Tracker.class));
        this.loadNull();
        this.storeLocal(this.tracerVarId);
        Label startLabel = new Label();
        Label endLabel = new Label();
        Label exceptionLabel = new Label();
        this.mv.visitTryCatchBlock(startLabel, endLabel, exceptionLabel, "java/lang/Throwable");
        this.mv.visitLabel(startLabel);
        this.mv.visitMethodInsn(184, AGENT_INTERNAL_NAME, HANDLE_NAME, HANDLE_METHOD_DESC, false);
        this.mv.visitLdcInsn(this.pointCutName);
        this.mv.visitLdcInsn(this.className);
        this.mv.visitLdcInsn(this.methodName);
        this.mv.visitLdcInsn(this.methodDesc);
        if ((this.methodAccess & 8) != 0) {
            this.loadNull();
        } else {
            this.loadThis();
        }
        this.loadArgArray();
        if (this.annotationAttributes != null) {
            this.mv.visitLdcInsn(this.annotationAttributes);
        } else {
            this.loadNull();
        }
        this.mv.visitMethodInsn(182, HANDLER_INTERNAL_NAME, "invokeTracker", TRACE_METHOD_DESC, false);
        this.storeLocal(this.tracerVarId);
        this.mv.visitLabel(endLabel);
        Label doneLabel = new Label();
        this.goTo(doneLabel);
        this.mv.visitLabel(exceptionLabel);
        this.mv.visitMethodInsn(182, "java/lang/Throwable", "printStackTrace", "()V", false);
        this.mv.visitLabel(doneLabel);
        JavaAgent.logger.log(Level.TRACE, "Successfully instrumented method entry for {}.{}", this.className, this.methodName);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        super.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        super.visitLabel(endFinally);
        this.onFinally(191);
        super.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
            JavaAgent.logger.log(Level.TRACE, "Successfully instrumented method exit for {}.{}", this.className, this.methodName);
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
    }

    private void onFinally(int opcode) {
        Label doneLabel = new Label();
        this.loadLocal(this.tracerVarId);
        this.ifNull(doneLabel);
        if (opcode == 191) {
            this.exitWithException();
        } else {
            this.exitNormally(opcode);
        }
        this.visitLabel(doneLabel);
    }

    private void exitWithException() {
        this.dup();
        Type thType = Type.getType(Throwable.class);
        int th = this.newLocal(thType);
        this.storeLocal(th);
        this.mv.visitMethodInsn(184, AGENT_INTERNAL_NAME, HANDLE_NAME, HANDLE_METHOD_DESC, false);
        this.loadLocal(this.tracerVarId);
        this.loadLocal(th);
        this.mv.visitMethodInsn(182, HANDLER_INTERNAL_NAME, "exitTracker", "(Lcom/manageengine/apminsight/agent/trackers/Tracker;Ljava/lang/Throwable;)V", false);
    }

    private void exitNormally(int opcode) {
        Type returnType = Type.getReturnType(this.methodDesc);
        int returnVar = -1;
        JavaAgent.logger.log(Level.TRACE, "The return type for the method desc {} is {}", this.methodDesc, returnType);
        if (opcode != 177) {
            if (opcode == 176) {
                this.dup();
            } else {
                if (opcode == 173 || opcode == 175) {
                    this.dup2();
                } else {
                    this.dup();
                }
                returnType = this.loadReturnValueAsObject(returnType);
            }
            returnVar = this.newLocal(returnType);
            this.storeLocal(returnVar, returnType);
        }
        this.mv.visitMethodInsn(184, AGENT_INTERNAL_NAME, HANDLE_NAME, HANDLE_METHOD_DESC, false);
        this.loadLocal(this.tracerVarId);
        this.mv.visitIntInsn(17, opcode);
        if (opcode == 177) {
            this.loadNull();
        } else {
            this.loadLocal(returnVar);
        }
        this.mv.visitMethodInsn(182, HANDLER_INTERNAL_NAME, "exitTracker", "(Lcom/manageengine/apminsight/agent/trackers/Tracker;ILjava/lang/Object;)V", false);
    }

    private Type loadReturnValueAsObject(Type returnType) {
        if (returnType.equals(Type.BYTE_TYPE)) {
            returnType = Type.getType(Byte.class);
            this.invokeStatic(returnType, new Method("valueOf", "(B)Ljava/lang/Byte;"));
        } else if (returnType.equals(Type.SHORT_TYPE)) {
            returnType = Type.getType(Short.class);
            this.invokeStatic(returnType, new Method("valueOf", "(S)Ljava/lang/Short;"));
        } else if (returnType.equals(Type.INT_TYPE)) {
            returnType = Type.getType(Integer.class);
            this.invokeStatic(returnType, new Method("valueOf", "(I)Ljava/lang/Integer;"));
        } else if (returnType.equals(Type.LONG_TYPE)) {
            returnType = Type.getType(Long.class);
            this.invokeStatic(returnType, new Method("valueOf", "(J)Ljava/lang/Long;"));
        } else if (returnType.equals(Type.BOOLEAN_TYPE)) {
            returnType = Type.getType(Boolean.class);
            this.invokeStatic(returnType, new Method("valueOf", "(Z)Ljava/lang/Boolean;"));
        } else if (returnType.equals(Type.CHAR_TYPE)) {
            returnType = Type.getType(Character.class);
            this.invokeStatic(returnType, new Method("valueOf", "(C)Ljava/lang/Character;"));
        } else if (returnType.equals(Type.FLOAT_TYPE)) {
            returnType = Type.getType(Float.class);
            this.invokeStatic(returnType, new Method("valueOf", "(F)Ljava/lang/Float;"));
        } else if (returnType.equals(Type.DOUBLE_TYPE)) {
            returnType = Type.getType(Double.class);
            this.invokeStatic(returnType, new Method("valueOf", "(D)Ljava/lang/Double;"));
        } else {
            this.pop();
            this.loadNull();
            JavaAgent.logger.trace("Default block is called");
        }
        return returnType;
    }

    public void loadNull() {
        this.mv.visitInsn(1);
    }
}

