/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.instrumentation.InstrumentationUtil;
import com.manageengine.org.objectweb.asm.ClassReader;
import com.manageengine.org.objectweb.asm.ClassWriter;

public class ByteCodeWriter
extends ClassWriter {
    static final String OBJECT_REPRESENTATION = "java/lang/Object";
    ClassLoader classLoader;
    String className;
    String superClassName;

    public ByteCodeWriter(ClassReader classReader, ClassLoader loader) {
        super(classReader, InstrumentationUtil.getClassWriterFlag(classReader));
        this.classLoader = loader;
        this.className = classReader.getClassName();
        this.superClassName = classReader.getSuperName();
    }

    @Override
    protected String getCommonSuperClass(String className1, String className2) {
        Class<?> class2;
        Class<?> class1;
        if (className1.equals(className2)) {
            return className1;
        }
        if (className1.equals(OBJECT_REPRESENTATION) || className2.equals(OBJECT_REPRESENTATION)) {
            return OBJECT_REPRESENTATION;
        }
        if (this.className.matches(className1 + "|" + className2)) {
            return OBJECT_REPRESENTATION;
        }
        if (this.className.equals(className1)) {
            if (this.superClassName.equals(className2)) {
                return className2;
            }
            className2 = this.superClassName;
        } else if (this.className.equals(className2)) {
            if (this.superClassName.equals(className1)) {
                return className1;
            }
            className1 = this.superClassName;
        }
        if (this.classLoader == null) {
            try {
                return super.getCommonSuperClass(className1, className2);
            }
            catch (Throwable th) {
                return OBJECT_REPRESENTATION;
            }
        }
        try {
            class1 = Class.forName(className1.replace('/', '.'), false, this.classLoader);
            class2 = Class.forName(className2.replace('/', '.'), false, this.classLoader);
        }
        catch (Exception th) {
            throw new RuntimeException(th.getMessage());
        }
        if (class1.isAssignableFrom(class2)) {
            return className1;
        }
        if (class2.isAssignableFrom(class1)) {
            return className2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return OBJECT_REPRESENTATION;
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }
}

