/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.db;

import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutPropertiesPoolService;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.DBInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.db.PrepareStatementTracker;

public class ConnectionInterceptorDefinition
extends DBInterceptorDefinition {
    private static final String[] PREPARESTATEMENT_METHOD_DESC = new String[]{"(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;Z)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;"};

    public ConnectionInterceptorDefinition() {
        super(ConnectionInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("java/sql/Connection"), new ClassMatcher("com/mysql/jdbc/ConnectionImpl"), new InterfaceTypeMatcher("com/ibm/db2/jcc/DB2Connection"), new ClassMatcher("oracle/jdbc/driver/OracleConnection"), new ClassMatcher("com/ibm/ws/rsadapter/jdbc/WSJdbcConnection"), new ClassMatcher("oracle/jdbc/driver/T4CDriverExtension"), new ClassMatcher("weblogic/jdbc/wrapper/Connection"), new ClassTypeMatcher("weblogic/jdbc/wrapper/Connection"), new ClassMatcher("org/postgresql/jdbc2/AbstractJdbc2Connection"), new ClassMatcher("org/postgresql/jdbc3/AbstractJdbc3Connection"), new ClassMatcher("org/postgresql/jdbc/PgConnection"), new ClassMatcher("com/sybase/jdbc2/jdbc/SybConnection"), new ClassMatcher("com/sybase/jdbc3/jdbc/SybConnection"), new ClassMatcher("com/sybase/jdbc4/jdbc/SybConnection"), new ClassMatcher("com/sybase/jdbc4/jdbc/SybConnectionProxy"), new ClassMatcher("com/ibm/as400/access/AS400JDBCConnection"), new ClassMatcher("com/ibm/as400/access/JDConnectionProxy"), new ClassMatcher("com/informix/jdbc/IfxSqliConnect"), new InterfaceTypeMatcher("com/microsoft/sqlserver/jdbc/ISQLServerConnection")), null, new ManyMethodMatcher(new MethodMatcher("prepareStatement", PREPARESTATEMENT_METHOD_DESC), new MethodMatcher("allocatePreparedStatement", new String[]{"(Loracle/jdbc/driver/PhysicalConnection;Ljava/lang/String;II)Loracle/jdbc/driver/OraclePreparedStatement;", "(Loracle/jdbc/driver/PhysicalConnection;Ljava/lang/String;Ljava/util/Properties;)Loracle/jdbc/driver/OraclePreparedStatement;"}), new MethodMatcher("allocateCallableStatement", new String[]{"(Loracle/jdbc/driver/PhysicalConnection;Ljava/lang/String;II)Loracle/jdbc/driver/OracleCallableStatement;", "(Loracle/jdbc/driver/PhysicalConnection;Ljava/lang/String;Ljava/util/Properties;)Loracle/jdbc/driver/OracleCallableStatement;"}), new MethodMatcher("prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;"), new MethodMatcher("prepareCall", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;"), new MethodMatcher("prepareCall", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;")));
    }

    @Override
    public Tracker getTracker(String interceptedClz, String interceptedMethod, Object thisObj, Object[] args) {
        ApplicationConfig config = SequenceSpace.SEQUENCE_BOOK.get().getConfig();
        if (config == null || !config.captureSql) {
            return null;
        }
        String sql = null;
        if ("allocatePreparedStatement".equals(interceptedMethod) || "allocateCallableStatement".equals(interceptedMethod)) {
            sql = args.length > 1 ? (String)args[1] : null;
        } else {
            String string = sql = args.length > 0 ? (String)args[0] : null;
        }
        if (sql != null) {
            return new PrepareStatementTracker(PointcutPropertiesPoolService.getOrCreateDBPointcutProperties(interceptedClz, interceptedMethod, this.getComponent(interceptedClz)), sql);
        }
        return null;
    }
}

