/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class DBInterceptorDefinition
extends TracingInterceptorDefinition {
    protected Map<Pattern, Component> dbComponents = new TreeMap<Pattern, Component>(new Comparator<Pattern>(){

        @Override
        public int compare(Pattern p1, Pattern p2) {
            int val = p2.pattern().length() - p1.pattern().length();
            if (val == 0) {
                return p1.pattern().equals(p2.pattern()) ? 0 : 1;
            }
            return val;
        }
    });

    public DBInterceptorDefinition(String interceptorName, ClassTypeMatcher classTypeMatcher, MethodMatcher excludeMethodMatcher, MethodMatcher includeMethodMatcher) {
        super(interceptorName, classTypeMatcher, excludeMethodMatcher, includeMethodMatcher);
        try {
            this.dbComponents.put(Pattern.compile("com/mysql/.*"), Component.MYSQL);
            this.dbComponents.put(Pattern.compile("com/ibm/db2/.*"), Component.IBMDB2);
            this.dbComponents.put(Pattern.compile("oracle/.*"), Component.ORACLE);
            this.dbComponents.put(Pattern.compile("org/postgresql/.*"), Component.PGSQL);
            this.dbComponents.put(Pattern.compile("com/sybase/.*"), Component.SYBASE);
            this.dbComponents.put(Pattern.compile("com/ibm/as400/.*"), Component.IBMDB2);
            this.dbComponents.put(Pattern.compile("com/informix/.*"), Component.INFORMIX);
            this.dbComponents.put(Pattern.compile("com/microsoft/.*"), Component.MSSQL);
        }
        catch (Exception ee) {
            JavaAgent.logger.warn("DBInterceptorDefinition - Exception while initializing dbComponents : " + ee.getMessage());
        }
    }

    public Component getComponent(String className) {
        for (Map.Entry<Pattern, Component> entry : this.dbComponents.entrySet()) {
            if (!entry.getKey().matcher(className).matches()) continue;
            return entry.getValue();
        }
        return this.getComponent();
    }

    public final Component getComponent() {
        return Component.JDBC;
    }
}

