/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient;

import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HTTPTrackerGroup;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpURLConnectionTracker;
import com.manageengine.apminsight.agent.util.ConcurrentWeakDictionary;

public class JavaHttpURLConnectionInterceptorDefinition
extends TracingInterceptorDefinition {
    private static final ConcurrentWeakDictionary<Object, Tracker> WEAK_REF_HOLDER = new ConcurrentWeakDictionary(64, 0.75f, 100);

    public JavaHttpURLConnectionInterceptorDefinition() {
        super(JavaHttpURLConnectionInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("java/net/HttpURLConnection"), new ClassTypeMatcher("java/net/HttpURLConnection")), null, new ManyMethodMatcher(new MethodMatcher("connect", "()V"), new MethodMatcher("getResponseCode", "()I"), new MethodMatcher("getInputStream", "()Ljava/io/InputStream;"), new MethodMatcher("getOutputStream", "()Ljava/io/OutputStream;")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        HTTPTrackerGroup returnObj = null;
        HttpURLConnectionTracker tracker = null;
        HttpClientPointcutProperties p = new HttpClientPointcutProperties(className, methodName);
        HTTPTrackerGroup trackerGroup = (HTTPTrackerGroup)WEAK_REF_HOLDER.get(thisObj);
        if (trackerGroup == null) {
            trackerGroup = new HTTPTrackerGroup(p, thisObj, args);
            WEAK_REF_HOLDER.putIfNotExists(thisObj, trackerGroup);
            returnObj = trackerGroup;
        }
        tracker = new HttpURLConnectionTracker(trackerGroup, p, thisObj, args);
        return returnObj != null ? trackerGroup : tracker;
    }
}

