/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.reactor;

import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.BlockingSpringWebClientTracker;
import java.lang.reflect.Field;

public class BlockingReactorPublisherInterceptorDefinition
extends TracingInterceptorDefinition {
    public BlockingReactorPublisherInterceptorDefinition() {
        super(BlockingReactorPublisherInterceptorDefinition.class.getName(), new ClassMatcher("reactor/core/publisher/Mono"), null, new ManyMethodMatcher(new MethodMatcher("block", new String[]{"()Ljava/lang/Object;", "(Ljava/time/Duration;)Ljava/lang/Object;"}), new MethodMatcher("blockOptional", new String[]{"()Ljava/util/Optional;", "(Ljava/time/Duration;)Ljava/util/Optional;"})));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        Object monoSupplier = this.getMonoSupplier(thisObj);
        if (this.isSpringWebClientPublisher(monoSupplier)) {
            return new BlockingSpringWebClientTracker(new HttpClientPointcutProperties(className, methodName), thisObj, args, this.getRequestBodyUriSpec(monoSupplier));
        }
        return null;
    }

    private boolean isSpringWebClientPublisher(Object monoSupplier) {
        return monoSupplier != null && monoSupplier.getClass().getSimpleName().contains("WebClient");
    }

    private Object getMonoSupplier(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            if (clazz.getSimpleName().equals("MonoDefer")) {
                return this.getSupplierFromMonoDefer(obj);
            }
            if (clazz.getSimpleName().equals("MonoFlatMap")) {
                Class<?> monoOperatorClass = clazz.getSuperclass().getSuperclass();
                Field sourceField = monoOperatorClass.getDeclaredField("source");
                sourceField.setAccessible(true);
                Object monoDeferObj = sourceField.get(obj);
                return this.getSupplierFromMonoDefer(monoDeferObj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object getSupplierFromMonoDefer(Object monoDeferObj) throws Exception {
        Field supplierField = monoDeferObj.getClass().getDeclaredField("supplier");
        supplierField.setAccessible(true);
        return supplierField.get(monoDeferObj);
    }

    private Object getRequestBodyUriSpec(Object monoSupplier) {
        try {
            Field arg1 = monoSupplier.getClass().getDeclaredField("arg$1");
            arg1.setAccessible(true);
            return arg1.get(monoSupplier);
        }
        catch (Exception e) {
            return null;
        }
    }
}

