/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jmx;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.jmx.JmxBean;
import com.manageengine.apminsight.agent.jmx.JmxBeanOperation;
import com.manageengine.apminsight.agent.jmx.JmxExtension;
import com.manageengine.apminsight.agent.jmx.JmxValue;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;

public class JmxExecutioner {
    private MBeanServer mBeanServer;
    private Pattern pattern = Pattern.compile("(\\{([\\w-]+)\\})");

    public Set<JmxValue> doExecute(JmxExtension jmxExtn) {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (JmxBeanOperation operation : jmxExtn.getJmxBeanOperations()) {
            this.doInvokeOperation(operation);
        }
        HashSet<JmxValue> values = new HashSet<JmxValue>();
        for (JmxBean bean : jmxExtn.getJmxBeans()) {
            values.addAll(this.doFetchAttribute(bean));
        }
        return values;
    }

    private void doInvokeOperation(JmxBeanOperation jmxOperation) {
        try {
            this.mBeanServer.invoke(new ObjectName(jmxOperation.getObjectName()), jmxOperation.getOperation(), jmxOperation.getParameterValues(), jmxOperation.getParameterTypes());
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[JmxExecution] Error invoking operation " + jmxOperation.toString());
        }
    }

    private Set<JmxValue> doFetchAttribute(JmxBean bean) {
        HashSet<JmxValue> values = new HashSet<JmxValue>();
        try {
            Set<ObjectName> mBeans = this.mBeanServer.queryNames(new ObjectName(bean.getBean()), null);
            for (ObjectName mBean : mBeans) {
                String jmxMetricName = this.getName(mBean, bean.getName());
                HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                for (String attribute : bean.getAttributes()) {
                    try {
                        Object attributeValue = this.getAttribute(mBean, attribute);
                        attributeMap.put(jmxMetricName + "-" + attribute, attributeValue);
                    }
                    catch (Exception e) {
                        JavaAgent.logger.log(Level.WARN, "[JmxExecution] Unable to extract attribute {} of JmxBean {}. Exception: {} Message: {}", attribute, jmxMetricName, e.getClass().getName(), e.getMessage());
                    }
                }
                values.add(new JmxValue(attributeMap));
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[JmxExecution] Error occurred while processing jmx bean " + bean, e);
        }
        return values;
    }

    private Object getAttribute(ObjectName objectName, String attribute) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        String[] attr = attribute.split("\\.");
        Object attributeValue = this.mBeanServer.getAttribute(objectName, attr[0]);
        if (attributeValue instanceof Attribute) {
            attributeValue = ((Attribute)attributeValue).getValue();
        } else if (attributeValue instanceof CompositeDataSupport) {
            attributeValue = ((CompositeDataSupport)attributeValue).get(attr[1]);
        }
        return attributeValue;
    }

    private String getName(ObjectName objectName, String jmxName) {
        try {
            Matcher matcher = this.pattern.matcher(jmxName);
            while (matcher.find()) {
                String key = matcher.group(2);
                jmxName = jmxName.replace(matcher.group(1), objectName.getKeyProperty(key));
            }
            jmxName = jmxName.replaceAll("[ /\"]*", "");
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[JmxExecution] Unable to get proper jmx name, returning the default bean name");
        }
        return jmxName;
    }
}

