/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.logging;

import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.apache.logging.log4j.core.Logger;

public class AgentLogger {
    private Logger logger;

    public AgentLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLevel(String levelStr) {
        if (StringUtils.isEmptyString(levelStr)) {
            return;
        }
        if (levelStr.equals("WARNING")) {
            this.setLevel(Level.WARN);
        } else if (levelStr.equals("CRITICAL")) {
            this.setLevel(Level.FATAL);
        } else {
            Level level = Level.getLevel(levelStr);
            if (level != null) {
                this.setLevel(level);
            }
        }
    }

    private void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isEnabled(level);
    }

    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    public void log(Level level, String msg, Object param) {
        this.logger.log(level, msg, param);
    }

    public void log(Level level, String msg, Object ... params) {
        this.logger.log(level, msg, params);
    }

    public void log(Level level, String msg, Throwable th) {
        this.logger.log(level, msg, th);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String msg, Object ... params) {
        this.log(Level.INFO, msg, params);
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public void debug(String msg, Object ... params) {
        this.log(Level.DEBUG, msg, params);
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg);
    }

    public void trace(String msg, Object ... params) {
        this.log(Level.TRACE, msg, params);
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg);
    }

    public void warn(String msg, Throwable th) {
        this.log(Level.WARN, msg, th);
    }

    public void warn(String msg, Object ... params) {
        this.log(Level.WARN, msg, params);
    }

    public void fatal(String msg) {
        this.log(Level.FATAL, msg);
    }

    public void fatal(String msg, Throwable th) {
        this.log(Level.FATAL, msg, th);
    }

    public void fatal(String msg, Object ... params) {
        this.log(Level.FATAL, msg, params);
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg);
    }

    public void error(String msg, Throwable th) {
        this.log(Level.ERROR, msg, th);
    }

    public void error(String msg, Object ... params) {
        this.log(Level.ERROR, msg, params);
    }
}

