/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.ClassPackagePatterns;
import com.manageengine.apminsight.agent.memory.calc.EntryFields;
import com.manageengine.apminsight.agent.memory.calc.FieldHolder;
import com.manageengine.apminsight.agent.memory.calc.KeyValueEntryFields;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ReservedFields {
    protected static KeyValueEntryFields tableFields = null;
    protected static KeyValueEntryFields mapFields = null;
    protected static KeyValueEntryFields concurrentFields = null;
    private static Map<Class, Object> excludedClasses = new ConcurrentHashMap<Class, Object>();
    private static Map<Class, Map<String, FieldHolder[]>> mapFieldHolder = new ConcurrentHashMap<Class, Map<String, FieldHolder[]>>();
    private static final Field[] NO_FIELDS_ARRAY = new Field[0];
    private static final FieldHolder[] NO_FIELDS_HOLDER = new FieldHolder[0];
    private ClassPackagePatterns classConfig;
    public static String hMap = HashMap.class.getName();
    public static String hTable = Hashtable.class.getName();
    public static String cHMap = ConcurrentHashMap.class.getName();
    public static String cHMapSegment = ConcurrentHashMap.class.getName() + "$Segment";
    public static String nonFairSync = ConcurrentHashMap.class.getName() + "$NonfairSync";
    public static String fairSync = ReentrantLock.class.getName() + "$Sync";
    protected static Class mapEntry = null;
    protected static Class tableEntry = null;
    protected static Class concurrentEntry = null;
    protected static Class concurrentSegment = null;
    protected static Class reentrantNonFair = null;
    protected static Class reentrantFair = null;
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static IdentityHashMap<Class, Boolean> markedClasses = new IdentityHashMap(16);

    protected ReservedFields(ClassPackagePatterns classNameConfig) {
        this.classConfig = classNameConfig;
        if (!isInitialized.compareAndSet(false, true)) {
            return;
        }
        this.initProperties();
    }

    private void initProperties() {
        EntryFields hasmMapEntryObj = new EntryFields(HashMap.class);
        EntryFields hashTableEntryObj = new EntryFields(Hashtable.class);
        EntryFields concurrentEntryObj = new EntryFields(ConcurrentHashMap.class);
        mapEntry = hasmMapEntryObj.getEntryClass();
        tableEntry = hashTableEntryObj.getEntryClass();
        concurrentEntry = concurrentEntryObj.getEntryClass();
        concurrentSegment = new EntryFields(ConcurrentHashMap.class, true).getEntryClass();
        reentrantNonFair = new EntryFields(ReentrantLock.class, false).getEntryClass();
        reentrantFair = new EntryFields(ReentrantLock.class, true).getEntryClass();
        tableFields = hashTableEntryObj.getEntryFields();
        mapFields = hasmMapEntryObj.getEntryFields();
        concurrentFields = concurrentEntryObj.getEntryFields();
        markedClasses.put(BigDecimal.class, Boolean.TRUE);
        markedClasses.put(BigInteger.class, Boolean.TRUE);
        markedClasses.put(mapEntry, Boolean.TRUE);
        markedClasses.put(tableEntry, Boolean.TRUE);
        markedClasses.put(concurrentEntry, Boolean.TRUE);
        markedClasses.put(concurrentSegment, Boolean.TRUE);
        markedClasses.put(reentrantNonFair, Boolean.TRUE);
        markedClasses.put(reentrantFair, Boolean.TRUE);
    }

    protected FieldHolder[] fetchFields(Class cls) {
        Map<String, FieldHolder[]> fieldMap = mapFieldHolder.get(cls);
        FieldHolder[] fields = null;
        if (fieldMap == null) {
            fieldMap = this.fetchAvailableFields(cls);
            fields = fieldMap.get("object");
            mapFieldHolder.put(cls, fieldMap);
        } else {
            fields = fieldMap.get("object");
        }
        return fields;
    }

    protected FieldHolder[] fetchFields(Class cls, String type) {
        Map<String, FieldHolder[]> fieldMap = mapFieldHolder.get(cls);
        FieldHolder[] fields = null;
        if (fieldMap == null) {
            fieldMap = this.fetchAvailableFields(cls);
            fields = fieldMap.get(type);
            mapFieldHolder.put(cls, fieldMap);
        } else {
            fields = fieldMap.get(type);
        }
        return fields;
    }

    protected boolean isFilteredClass(Class cls) {
        return markedClasses.containsKey(cls) || this.fetchFields(cls).length == 0;
    }

    private Map<String, FieldHolder[]> fetchAvailableFields(Class clazz) {
        HashMap<String, FieldHolder[]> fieldMap = new HashMap<String, FieldHolder[]>();
        if (excludedClasses.containsKey(clazz)) {
            fieldMap.put("object", NO_FIELDS_HOLDER);
            fieldMap.put("primitive", NO_FIELDS_HOLDER);
            return fieldMap;
        }
        ArrayList fieldList = new ArrayList();
        ArrayList primitiveFieldList = new ArrayList();
        while (clazz != null) {
            if (clazz != Reference.class) {
                Field[] fields = NO_FIELDS_ARRAY;
                Map<Object, Object> classMap = new HashMap();
                try {
                    fields = clazz.getDeclaredFields();
                }
                catch (Exception ex) {
                    excludedClasses.put(clazz, Boolean.TRUE);
                    JavaAgent.logger.fatal("Declared fields are not available for the class " + clazz, ex);
                }
                classMap = this.fetchAvailableFields(fields);
                if (classMap.containsKey("object") && classMap.get("object") != null) {
                    fieldList.addAll((Collection)classMap.get("object"));
                }
                if (classMap.containsKey("primitive_object") && classMap.get("primitive_object") != null) {
                    primitiveFieldList.addAll((Collection)classMap.get("primitive_object"));
                }
            }
            clazz = clazz.getSuperclass();
        }
        if (!fieldList.isEmpty()) {
            fieldMap.put("object", fieldList.toArray(new FieldHolder[fieldList.size()]));
        } else {
            fieldMap.put("object", NO_FIELDS_HOLDER);
        }
        if (!primitiveFieldList.isEmpty()) {
            fieldMap.put("primitive", primitiveFieldList.toArray(new FieldHolder[primitiveFieldList.size()]));
        } else {
            fieldMap.put("primitive", NO_FIELDS_HOLDER);
        }
        return fieldMap;
    }

    private Map<String, ArrayList<FieldHolder>> fetchAvailableFields(Field[] fieldArr) {
        HashMap<String, ArrayList<FieldHolder>> fieldMap = new HashMap<String, ArrayList<FieldHolder>>();
        ArrayList<FieldHolder> fieldList = new ArrayList<FieldHolder>();
        ArrayList<FieldHolder> primitiveFieldList = new ArrayList<FieldHolder>();
        for (Field field : fieldArr) {
            if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("this$")) continue;
            field.setAccessible(true);
            FieldHolder fieldWrapper = null;
            FieldHolder primitiveFieldWrapper = null;
            Class<?> fieldClass = field.getType();
            Class<?> compType = fieldClass.getComponentType();
            if (compType != null && !Enum.class.isAssignableFrom(compType) && this.classConfig.includeClass(compType)) {
                if (compType.isPrimitive()) {
                    primitiveFieldWrapper = new FieldHolder(field, true);
                } else {
                    fieldWrapper = new FieldHolder(field, true);
                }
            } else if (!Enum.class.isAssignableFrom(fieldClass) && this.classConfig.includeClass(fieldClass)) {
                if (fieldClass.isPrimitive()) {
                    primitiveFieldWrapper = new FieldHolder(field, false);
                } else {
                    fieldWrapper = new FieldHolder(field, false);
                }
            }
            if (fieldWrapper != null) {
                fieldList.add(fieldWrapper);
            }
            if (primitiveFieldWrapper == null) continue;
            primitiveFieldList.add(primitiveFieldWrapper);
        }
        if (fieldList != null && !fieldList.isEmpty()) {
            fieldMap.put("object", fieldList);
        }
        if (primitiveFieldList != null && !primitiveFieldList.isEmpty()) {
            fieldMap.put("primitive_object", primitiveFieldList);
        }
        return fieldMap;
    }

    void setManualExcludes(Set<String> manualExcludes) {
        this.classConfig.setManualExcludes(manualExcludes);
    }

    void setManualIncludes(Set<String> manualIncludes) {
        this.classConfig.setManualIncludes(manualIncludes);
    }

    public static void main(String[] args) {
        new ReservedFields(null);
    }
}

