/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.MemoryLeakCapturingTask;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.memoryleaks.monitor.Histogram;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import com.manageengine.org.json.simple.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MemoryLeaksEvents {
    private List<Object> dataEventsList = new ArrayList<Object>();
    private List<Object> uiEventsList = new ArrayList<Object>();
    private ScheduledFuture<?> metricDispatcherFuture = null;

    private MemoryLeaksEvents() {
    }

    public static MemoryLeaksEvents getInstance() {
        return MemoryLeaksEventsFactory.INSTANCE;
    }

    protected void initialize() {
        if (this.metricDispatcherFuture != null && !this.metricDispatcherFuture.isCancelled()) {
            this.metricDispatcherFuture.cancel(false);
        }
        this.metricDispatcherFuture = SchedulerManager.getGlobalScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MemoryLeaksEvents.this.dispatchMetrics();
            }
        }, 30L, 60L, TimeUnit.SECONDS);
    }

    public void clear() {
        if (this.metricDispatcherFuture != null) {
            this.metricDispatcherFuture.cancel(true);
            this.metricDispatcherFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMetrics() {
        block15: {
            try {
                if (!ContextInfoManager.getInstance().getDefaultContextInfo().isActive()) {
                    AutomaticLeakDetection.getInstance();
                    if (AutomaticLeakDetection.isActive()) {
                        if (MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled) {
                            MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled = false;
                        }
                        AutomaticLeakDetection.getInstance().deActivate();
                    }
                    return;
                }
                ArrayList<Object> data = new ArrayList<Object>();
                List<Object> list = this.uiEventsList;
                synchronized (list) {
                    if (!this.uiEventsList.isEmpty()) {
                        data.addAll(this.uiEventsList);
                        this.uiEventsList.clear();
                    }
                }
                list = this.dataEventsList;
                synchronized (list) {
                    if (!this.dataEventsList.isEmpty()) {
                        data.addAll(this.dataEventsList);
                        this.dataEventsList.clear();
                    }
                }
                if (data.isEmpty() || data.size() <= 0) break block15;
                try {
                    JavaAgent.getInstance().getAgentService().sendDataToServer(ContextInfoManager.getInstance().getDefaultContextInfo(), "memory_leak_data", data);
                }
                catch (Exception e) {
                    JavaAgent.logger.fatal("Exception while dispatching metrics.", e);
                }
                JavaAgent.logger.fatal("Leak Data:");
                JavaAgent.logger.fatal(((Object)data).toString());
                data.clear();
            }
            catch (Exception e) {
                JavaAgent.logger.fatal("Exception in dispatchMetrics", e);
            }
        }
    }

    protected synchronized void finish() {
        if (this.metricDispatcherFuture != null) {
            this.metricDispatcherFuture.cancel(false);
            this.metricDispatcherFuture = null;
        }
        this.dataEventsList.clear();
    }

    public void addDataEvent(ObjectDetails objectDetails) {
        JSONObject json = new JSONObject();
        json.put("id", objectDetails.getObjectUUID());
        json.put("elements_count", objectDetails.getSize());
        json.put("class_name", objectDetails.getClazzName());
        json.put("object_type", objectDetails.getObjectType());
        json.put("age_in_millis", objectDetails.getDescription());
        json.put("capture_time", objectDetails.getObjectCapturedTime());
        json.put("update_time", System.currentTimeMillis());
        Histogram histogram = objectDetails.getHistogram();
        if (histogram != null) {
            JSONObject histoArr = new JSONObject();
            histoArr = histogram.getHistogramAsJson();
            json.put("size_in_bytes", histoArr.get("size_in_bytes"));
            json.put("error_info", histoArr.get("error_info"));
            json.put("error_params", histoArr.get("error_params"));
        }
        json.put("type", MetricType.DATA_METRIC.getType());
        this.addDataEvent(json);
    }

    public void addDataEvent(Histogram histogram, int currentSize, Boolean isPotentialLeak) {
        if (histogram != null) {
            JSONObject json = new JSONObject();
            json = histogram.getHistogramAsJson();
            json.put("elements_count", currentSize);
            json.put("potential_leak", isPotentialLeak);
            json.put("update_time", System.currentTimeMillis());
            json.put("type", MetricType.OBJECT_SUMMARY.getType());
            this.addDataEvent(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataEvent(JSONObject json) {
        List<Object> list = this.dataEventsList;
        synchronized (list) {
            this.dataEventsList.add(json);
        }
    }

    public void addUiEvent(long hashId, String data) {
        this.addUiEvent(hashId, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUiEvent(long hashId, String data, List params) {
        JSONObject json = new JSONObject();
        json.put("id", hashId);
        json.put("type", MetricType.UI_METRIC.getType());
        json.put("data", data);
        json.put("params", params);
        json.put("update_time", System.currentTimeMillis());
        List<Object> list = this.uiEventsList;
        synchronized (list) {
            this.uiEventsList.add(json);
        }
    }

    public static enum MetricType {
        DATA_METRIC(1001),
        UI_METRIC(1002),
        OBJECT_SUMMARY(1003),
        OBJECT_PERSISTANCE(1004),
        TRANSACTION_TRACE(1005),
        GROWTH_REPORT(1006),
        REMOVED_IDS(1007);

        int type;

        private MetricType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class MemoryLeaksEventsFactory {
        private static final MemoryLeaksEvents INSTANCE = new MemoryLeaksEvents();

        private MemoryLeaksEventsFactory() {
        }
    }
}

