/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor;

import com.manageengine.org.json.simple.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Histogram {
    private int id;
    private long objectUUID = -1L;
    private long size;
    private String name;
    private String clazzName;
    private String errorDetails;
    private Map<String, AtomicLong> objectSize;
    private Map<String, AtomicInteger> objectCount;
    private List errorParams;

    public Histogram(int id, String name, String clazzName, long size, Map<String, AtomicInteger> objectCount, Map<String, AtomicLong> objectSize, String errorDetails, List errorParams) {
        this.id = id;
        this.size = size;
        this.name = name;
        this.clazzName = clazzName;
        this.errorDetails = errorDetails;
        this.objectCount = objectCount;
        this.objectSize = objectSize;
        this.errorParams = errorParams;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getObjectUUID() {
        return this.objectUUID;
    }

    public void setObjectUUID(long objectUUID) {
        this.objectUUID = objectUUID;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Map<String, AtomicInteger> getObjectCount() {
        return this.objectCount;
    }

    public Map<String, AtomicLong> getObjectSize() {
        return this.objectSize;
    }

    public Map<String, String> getObjectDetailAsMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.objectCount.size());
        for (String key : this.objectCount.keySet()) {
            StringBuilder value = new StringBuilder(String.valueOf(this.objectCount.get(key).get())).append(":").append(String.valueOf(this.objectSize.get(key).get()));
            result.put(key, value.toString());
        }
        return result;
    }

    public Map<String, String> getObjectCountAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.objectCount.keySet()) {
            result.put(key, String.valueOf(this.objectCount.get(key).get()));
        }
        return result;
    }

    public Map<String, String> getObjectDetailAsMap(int noOfElements) {
        int counter = 0;
        HashMap<String, String> map = new HashMap<String, String>(this.objectCount.size());
        for (String key : this.objectCount.keySet()) {
            StringBuilder value = new StringBuilder(String.valueOf(this.objectCount.get(key).get())).append(":").append(String.valueOf(this.objectSize.get(key).get()));
            map.put(key, value.toString());
            if (++counter <= noOfElements) continue;
            break;
        }
        return map;
    }

    public Map<String, String> getObjectSizeAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.objectSize.keySet()) {
            result.put(key, String.valueOf(this.objectSize.get(key).get()));
        }
        return result;
    }

    public JSONObject getHistogramAsJson() {
        JSONObject result = new JSONObject();
        result.put("id", this.objectUUID);
        result.put("size_in_bytes", this.size);
        result.put("class_name", this.clazzName);
        result.put("error_info", this.errorDetails);
        result.put("error_params", this.errorParams);
        if (this.objectCount != null) {
            result.put("class_count", JSONObject.toJSONString(this.objectCount));
        }
        if (this.objectSize != null) {
            result.put("class_size", JSONObject.toJSONString(this.objectSize));
        }
        return result;
    }

    public String toString() {
        String str = "id " + this.id + ", name " + this.name + ", clazzname " + this.clazzName + " total size : " + this.getSize() + "\n";
        return str;
    }
}

