/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor;

import com.manageengine.org.apache.commons.math3.stat.regression.SimpleRegression;

public class RegressionModel {
    private String name = null;
    private volatile int initialCount = 0;
    private int warmupTime = 0;
    private SimpleRegression srModel = new SimpleRegression();

    public RegressionModel(String name, int warmupTime) {
        this.warmupTime = warmupTime;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(long timestamp, long dataPoint) {
        if (dataPoint < 0L) {
            return;
        }
        if (this.initialCount < this.warmupTime) {
            ++this.initialCount;
            return;
        }
        RegressionModel regressionModel = this;
        synchronized (regressionModel) {
            this.srModel.addData(timestamp, dataPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        RegressionModel regressionModel = this;
        synchronized (regressionModel) {
            this.srModel.clear();
        }
    }

    public String getObjectName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGrowthFactor() {
        long numberOfObservations;
        double rSquared;
        double slope;
        RegressionModel regressionModel = this;
        synchronized (regressionModel) {
            slope = this.srModel.getSlope();
            rSquared = this.srModel.getRSquare();
            numberOfObservations = this.srModel.getN();
        }
        if (numberOfObservations > 15L && slope > 0.0 && rSquared >= 0.47) {
            return Math.round(slope * 10000.0);
        }
        return 0L;
    }
}

