/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor.collections;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectRouter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.MemoryLeaksHolder;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.ObjectContainer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CollectionObjectCollector {
    private int currentId;
    Long creationMillis;
    private int containerCount = 0;
    private ObjectContainer currentContainer = new ObjectContainer();
    private List<ObjectContainer> containerArrList = new ArrayList<ObjectContainer>(1000);
    private List<WeakReference<Object>> validatorList = new ArrayList<WeakReference<Object>>();
    private volatile boolean collectorLimitReached = false;
    public volatile boolean isValidationHappened = false;
    public static final int SIZE = 4096;
    private static final int MAX_CONTAINERS = 256;
    private CollectionObjectRouter router = null;

    public CollectionObjectCollector(CollectionObjectRouter router) {
        this.router = router;
        this.currentId = this.router.collectorCounter++;
        this.creationMillis = System.currentTimeMillis() + 30000L;
        JavaAgent.logger.info(" ObjectCollector  Collector id : " + this.currentId + " is created.");
    }

    void addObject(Object obj) {
        try {
            if (this.collectorLimitReached) {
                ++this.router.objectLimitExceedCount;
                return;
            }
            ObjectContainer container = this.currentContainer;
            int inx = container.index.getAndIncrement();
            if (inx >= 4095) {
                this.createNewContainer(container);
                this.addObject(obj);
            } else {
                this.currentContainer.array[inx] = new WeakReference<Object>(obj);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception occured in addObject ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createNewContainer(ObjectContainer oldContainer) {
        if (this.collectorLimitReached || this.currentContainer != oldContainer) {
            return;
        }
        ObjectContainer existingOne = this.currentContainer;
        List<ObjectContainer> list = this.containerArrList;
        synchronized (list) {
            this.containerArrList.add(existingOne);
        }
        ++this.containerCount;
        if (this.containerCount >= 256) {
            this.collectorLimitReached = true;
            this.currentContainer = null;
            JavaAgent.logger.info("Collector Object Container limit exhaused - New Objects will not be tracked here after for this collector time");
        } else {
            this.currentContainer = new ObjectContainer();
            JavaAgent.logger.info("A latest array created in CollectionObjectCollector  with Collector id : " + this.currentId);
        }
    }

    public void collectionValidator() {
        if (this.containerArrList.size() != 0) {
            for (ObjectContainer container : this.containerArrList) {
                for (int i = 0; i < container.array.length; ++i) {
                    WeakReference<Object> weakObj = container.array[i];
                    if (weakObj == null || weakObj.get() == null) continue;
                    this.validatorList.add(weakObj);
                }
            }
            this.containerArrList.clear();
        }
        Iterator<WeakReference<Object>> iter = this.validatorList.iterator();
        while (iter.hasNext()) {
            WeakReference<Object> weakObj = iter.next();
            if (weakObj.get() != null) continue;
            iter.remove();
        }
        long elapsedTime = System.currentTimeMillis() - this.creationMillis;
        long minSpecifiedDuration = this.router.getCollectionMinAgeMins() * 60 * 1000;
        int allValidObjectsSize = -1;
        if (elapsedTime >= minSpecifiedDuration) {
            ArrayList<MemoryLeaksHolder> allValidObjects = new ArrayList<MemoryLeaksHolder>();
            for (WeakReference<Object> weakRefObj : this.validatorList) {
                if (weakRefObj.get() == null) continue;
                allValidObjects.add(new MemoryLeaksHolder(this.creationMillis, weakRefObj));
            }
            this.validatorList.clear();
            this.router.addToMemoryLeakCollectionList(allValidObjects);
            this.isValidationHappened = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void done() {
        boolean oldLimit = this.collectorLimitReached;
        this.collectorLimitReached = true;
        if (this.currentContainer != null) {
            List<ObjectContainer> list = this.containerArrList;
            synchronized (list) {
                this.containerArrList.add(this.currentContainer);
            }
            JavaAgent.logger.info(" CollectionObjectCollector finished, Collector id : " + this.currentId + " & oldlimit  is :" + oldLimit + ", & Exceeded object count" + this.router.objectLimitExceedCount);
        }
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public boolean isValidationHappened() {
        return this.isValidationHappened;
    }
}

