/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor.collections;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectRouter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObservation;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.MemoryLeaksHolder;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CropValidatedObjects
implements Runnable {
    LeakObservation leakObservationObj;
    CollectionObjectRouter router;
    private int collectionCapturePeriodMins;
    private int objectDurationInMins = 60;
    private volatile boolean enabled = true;
    private volatile boolean isProcessing = true;
    private ScheduledFuture<?> cropperFuture;
    private MemoryLeaksEvents eventSender = MemoryLeaksEvents.getInstance();

    public CropValidatedObjects(CollectionObjectRouter router, LeakObservation leaks) {
        this.router = router;
        this.leakObservationObj = leaks;
        this.objectDurationInMins = leaks.getObjectDurationInMins();
    }

    public void init() {
        this.cropperFuture = SchedulerManager.getGlobalScheduler().scheduleWithFixedDelay(this, this.objectDurationInMins * 60, 60L, TimeUnit.SECONDS);
        JavaAgent.logger.info("CropValidatedObjects: will start in [" + this.objectDurationInMins + "] minutes");
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.validation.start");
    }

    public void finishCropper() {
        this.enabled = Boolean.FALSE;
        this.isProcessing = Boolean.FALSE;
        if (this.cropperFuture != null) {
            this.cropperFuture.cancel(Boolean.FALSE);
        }
        JavaAgent.logger.info("CropValidatedObjects finished");
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.validation.stop");
    }

    public boolean isCropperProcessing() {
        return this.isProcessing;
    }

    @Override
    public void run() {
        if (this.enabled && this.leakObservationObj.isActive()) {
            MemoryLeaksHolder[] array;
            if (this.router.isObjectsCollectionsFinished()) {
                this.finishCropper();
            }
            if ((array = this.router.getMemoryLeakCollectionArr()) != null && array.length != 0) {
                ArrayList<MemoryLeaksHolder> validatedList = new ArrayList<MemoryLeaksHolder>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    MemoryLeaksHolder individualObject = array[i];
                    if (individualObject.getObject().get() == null) continue;
                    validatedList.add(individualObject);
                }
                this.leakObservationObj.addToObservationData(validatedList);
                JavaAgent.logger.info("CropValidatedObjects cropped -- " + validatedList.size());
                ArrayList<Integer> params = new ArrayList<Integer>();
                params.add(validatedList.size());
                this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.validation.size", params);
            }
        }
    }
}

