/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor.collections;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.memoryleaks.config.CollectionCounter;
import com.manageengine.apminsight.agent.memoryleaks.config.LeakDetectionConfig;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectRouter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CropValidatedObjects;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObjectAnalysis;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.MemoryLeaksHolder;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;

public class LeakObservation {
    private ArrayList<ArrayList<MemoryLeaksHolder>> observationSeries = new ArrayList();
    private CropValidatedObjects croppedObject;
    private CollectionObjectRouter router;
    private CollectionCounter counterObject;
    private LeakObjectAnalysis objectAnalyzer;
    protected ScheduledFuture<?> scheduleCropperFuture;
    private int captureTimeInMins;
    private int objectDurationInMins;
    private volatile boolean isActive = false;
    private AutomaticLeakDetection.OnDemandCollectionRecorder recorder;
    protected ScheduledFuture<?> analyzer;

    public LeakObservation(AutomaticLeakDetection.OnDemandCollectionRecorder recorder) {
        this.recorder = recorder;
        this.validateCaptureTimeInMins(recorder.getCaptureTimeInMins());
        this.objectDurationInMins = recorder.getObjectDurationInMins();
    }

    private void validateCaptureTimeInMins(int captureTimeInMins) {
        if (captureTimeInMins > LeakDetectionConfig.max_period_for_collection_recorder_in_mins) {
            int defaultTime = LeakDetectionConfig.max_period_for_collection_recorder_in_mins;
            this.captureTimeInMins = LeakDetectionConfig.max_period_for_collection_recorder_in_mins;
            JavaAgent.logger.warn("Capture time exceeded the maximum collection recorder time, time provided " + captureTimeInMins + " which should not be greater than " + defaultTime);
        } else {
            this.captureTimeInMins = captureTimeInMins;
        }
    }

    public void init() {
        this.isActive = true;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("LeakObservation is goint to start - Recording duration [").append(this.captureTimeInMins).append("] minutess, with objectDurationInMins [").append(this.objectDurationInMins).append("], Collection minimum Size (Deep) --").append(LeakDetectionConfig.minimum_size_for_qualifying_bytes).append("] minutess, Collection minimum size (Shallow) --").append(LeakDetectionConfig.minimum_elements_to_deep_size_collection).append("--");
        JavaAgent.logger.info(strBuilder.toString());
        this.router = new CollectionObjectRouter(SchedulerManager.getGlobalScheduler(), this);
        JavaAgent.logger.info("Collection Object router started");
        this.counterObject = new CollectionCounter(this);
        this.counterObject.init();
        JavaAgent.logger.info("Collection Counter started");
        this.croppedObject = new CropValidatedObjects(this.router, this);
        this.croppedObject.init();
        JavaAgent.logger.info("CropValidatedObjects started");
        this.objectAnalyzer = new LeakObjectAnalysis(this.router, this);
        this.objectAnalyzer.init();
        JavaAgent.logger.info("LeakObjectAnalysis started");
        MemoryLeaksEvents.getInstance().addUiEvent(0L, "apminsight.memoryleaks.observation.start");
    }

    public CollectionObjectRouter getRouter() {
        return this.router;
    }

    public int getCaptureTimeInMins() {
        return this.captureTimeInMins;
    }

    public int getObjectDurationInMins() {
        return this.objectDurationInMins;
    }

    public synchronized void addToObservationData(ArrayList<MemoryLeaksHolder> validatedList) {
        this.observationSeries.add(validatedList);
    }

    public synchronized void evacuateObservationData(ArrayList<ArrayList<MemoryLeaksHolder>> evacuateTo) {
        evacuateTo.addAll(this.observationSeries);
        this.observationSeries.clear();
    }

    public void addToRouter(Object collectionObj) {
        if (this.counterObject != null) {
            this.counterObject.addObjectToTrack(collectionObj);
        }
    }

    public void finishObservation() {
        this.setIsActive(false);
        this.finishRouting();
        this.finishCropping();
        this.finishAnalysis();
    }

    public void finishRouting() {
        try {
            this.router.finishAll();
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception in finishing the router [CollectionObjectRouter]", e);
        }
    }

    private void finishAnalysis() {
        try {
            this.objectAnalyzer.finishAll();
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception in finishing the leak object analyzer [LeakObjectAnalysis] ", e);
        }
    }

    protected void finishFromAnalyzer() {
        this.finishCounter();
        this.finishCropping();
        this.finishRouting();
        this.recorder.clear();
    }

    public void finishCounter() {
        try {
            this.counterObject.finish();
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception in finishing the crop validator [CollectionCounter] ", e);
        }
    }

    public void finishCropping() {
        try {
            this.croppedObject.finishCropper();
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception in finishing the crop validator [CropValidatedObjects] ", e);
        }
    }

    public boolean isCropperProcessing() {
        return this.croppedObject != null && this.croppedObject.isCropperProcessing();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

