/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPMetric
extends ComponentMetric {
    private long bytesIN_min = Long.MAX_VALUE;
    private long bytesIN_max = 0L;
    private long bytesIN = 0L;
    private long bytesOUT_min = Long.MAX_VALUE;
    private long bytesOUT_max = 0L;
    private long bytesOUT = 0L;
    private int bytesIN_count = 0;
    private int bytesOUT_count = 0;
    private Map<Integer, Integer> httpRespCodes = new HashMap<Integer, Integer>(){

        @Override
        public Integer put(Integer code, Integer i) {
            Integer old = super.put(code, i);
            if (old != null) {
                super.put(code, old + i);
            }
            return old;
        }
    };

    public void recordHttpRespCode(int httpRespCode) {
        this.httpRespCodes.put(httpRespCode, 1);
    }

    public void recordBytesInOut(long bytesIn, long bytesOut) {
        if (bytesIn > -1L) {
            this.bytesIN_min = Math.min(bytesIn, this.bytesIN_min);
            this.bytesIN_max = Math.max(bytesIn, this.bytesIN_max);
            this.bytesIN += bytesIn;
            ++this.bytesIN_count;
        }
        if (bytesOut > -1L) {
            this.bytesOUT_min = Math.min(bytesOut, this.bytesOUT_min);
            this.bytesOUT_max = Math.max(bytesOut, this.bytesOUT_max);
            this.bytesOUT += bytesOut;
            ++this.bytesOUT_count;
        }
    }

    public void recordHTTPData(HTTPMetric httpMetric) {
        this.httpRespCodes.putAll(httpMetric.httpRespCodes);
        this.bytesIN_min = Math.min(httpMetric.bytesIN_min, this.bytesIN_min);
        this.bytesIN_max = Math.max(httpMetric.bytesIN_max, this.bytesIN_max);
        this.bytesIN += httpMetric.bytesIN;
        this.bytesIN_count += httpMetric.bytesIN_count;
        this.bytesOUT_min = Math.min(httpMetric.bytesOUT_min, this.bytesOUT_min);
        this.bytesOUT_max = Math.max(httpMetric.bytesOUT_max, this.bytesOUT_max);
        this.bytesOUT += httpMetric.bytesOUT;
        this.bytesOUT_count += httpMetric.bytesOUT_count;
    }

    protected Map<String, Object> getHttpMetricDataInMap(Map<String, Object> sack) {
        if (!this.httpRespCodes.isEmpty()) {
            sack.put("httpcode", this.httpRespCodes);
        }
        if (this.bytesIN_count > 0) {
            List<Number> bytesINList = Arrays.asList(this.bytesIN, this.bytesIN_min == Long.MAX_VALUE ? 0L : this.bytesIN_min, this.bytesIN_max, this.bytesIN_count);
            sack.put("bytes_in", bytesINList);
        }
        if (this.bytesOUT_count > 0) {
            List<Number> bytesOUTList = Arrays.asList(this.bytesOUT, this.bytesOUT_min == Long.MAX_VALUE ? 0L : this.bytesOUT_min, this.bytesOUT_max, this.bytesOUT_count);
            sack.put("bytes_out", bytesOUTList);
        }
        return sack;
    }
}

