/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.api.CustomMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.ThreadMetric;
import com.manageengine.apminsight.agent.metrics.VirtualMachineMetric;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class JvmMetric
implements MetricData {
    private HashMap<String, List> memoryPool = new HashMap();
    private HashMap<String, List> garbageCollector = new HashMap();
    private HashMap<Long, List> deadlockedThreads = new LinkedHashMap<Long, List>();
    private List<Object> metaData = new ArrayList<Object>();
    private List<Object> rawData = new ArrayList<Object>();

    public void recordData(VirtualMachineMetric vmMetric, ThreadMetric threadMetric) {
        this.reset();
        this.memoryPool = vmMetric.memoryUsage;
        this.garbageCollector = vmMetric.garbageCollector;
        this.deadlockedThreads = threadMetric.deadlockedThreads;
        this.metaData.addAll(Arrays.asList(vmMetric.vmUpTime, vmMetric.availProcessors, vmMetric.totalLoadedClassCount, threadMetric.totalStartedCount));
        this.rawData.addAll(Arrays.asList(vmMetric.totalMemory, vmMetric.freeMemory, vmMetric.loadedClassCount, vmMetric.unloadedClassCount, vmMetric.jitCompilationTime, Float.valueOf(threadMetric.cpuUtil), threadMetric.liveCount, threadMetric.daemonCount, threadMetric.peakCount, threadMetric.sleepCount, threadMetric.totalCpuTime, threadMetric.totalUserTime));
        CustomMetric.increment("Blocked-Threads-Count", threadMetric.blockedThreadsCount);
    }

    public void reset() {
        this.memoryPool.clear();
        this.garbageCollector.clear();
        this.deadlockedThreads.clear();
        this.metaData.clear();
        this.rawData.clear();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.getDataInList(), out);
    }

    private List getDataInList() {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>(1);
        LinkedHashMap<String, Object> mapData = new LinkedHashMap<String, Object>();
        mapData.put("meta", this.metaData);
        mapData.put("raw", this.rawData);
        mapData.put("mp", this.memoryPool);
        mapData.put("gc", this.garbageCollector);
        mapData.put("dt", this.deadlockedThreads);
        data.add(Arrays.asList(mapData));
        return data;
    }

    public String toString() {
        return JavaAgentUtil.listToString(this.getDataInList());
    }
}

