/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class MetricName
implements JSONStreamAware {
    private String contextName;
    private String nameSpace;
    private String name;

    public MetricName(String context, String nameSpace, String name) {
        if (nameSpace == null || name == null) {
            throw new IllegalArgumentException("The name or namespace cannot be null");
        }
        this.name = name;
        this.nameSpace = nameSpace;
        this.contextName = context == null ? "" : context;
    }

    public MetricName(String nameSpace, String name) {
        this(null, nameSpace, name);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getContextName() {
        return this.contextName;
    }

    public int hashCode() {
        return this.nameSpace.hashCode() ^ this.name.hashCode() ^ this.contextName.hashCode();
    }

    public boolean equals(Object obj) {
        MetricName ns = (MetricName)obj;
        return this.name.equals(ns.name) && this.nameSpace.equals(ns.nameSpace) && this.contextName.equals(ns.contextName);
    }

    @Override
    public void writeJSONString(Writer out) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        map.put("ns", this.nameSpace);
        try {
            JSONObject.writeJSONString(map, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameSpace != null ? this.nameSpace : "").append(":").append(this.name);
        return sb.toString();
    }
}

